//-< SOCKIO.H >------------------------------------------------------*--------*
// GOODS                     Version 1.0         (c) 1997  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
//                                                                   *  /  \  *
//                          Created:      7-Jan-97    K.A. Knizhnik  * / [] \ *
//                          Last update: 23-Apr-97    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Socket abstraction
//-------------------------------------------------------------------*--------*

#ifndef __SOCKIO_H__
#define __SOCKIO_H__

#define DEFAULT_CONNECT_MAX_ATTEMPTS 100
#define DEFAULT_RECONNECT_TIMEOUT    1
#define DEFAULT_LISTEN_QUEUE_SIZE    5
#define LINGER_TIME                  10

//
// Abstract socket interface
//
class socket_t { 
  public: 
    virtual boolean   read(void* buf, size_t size) = 0;
    virtual boolean   write(void const* buf, size_t size) = 0;

    virtual boolean   is_ok() = 0; 
    virtual void      get_error_text(char* buf, size_t buf_size) = 0;

    //
    // This method is called by server to accept client connection
    //
    virtual socket_t* accept() = 0;

    //
    // Cancel accept operation and close socket
    //
    virtual boolean   cancel_accept() = 0;

    //
    // Shutdown socket: prohibite write and read operations on socket
    //
    virtual boolean   shutdown() = 0;

    //
    // Close socket
    //
    virtual boolean   close() = 0;

    //
    // Create client socket connected to local or global server socket
    //
    enum socket_domain { 
	sock_any_domain,   // domain is chosen automatically
	sock_local_domain, // local domain (i.e. Unix domain socket) 
	sock_global_domain // global domain (i.e. INET sockets) 
    };

    static socket_t*  connect(char const* address, 
			      socket_domain domain = sock_any_domain, 
			      int max_attempts = DEFAULT_CONNECT_MAX_ATTEMPTS,
			      time_t timeout = DEFAULT_RECONNECT_TIMEOUT);
    
    //
    // Create local domain socket
    //
    static socket_t*  create_local(char const* address,
				   int listen_queue_size = 
				       DEFAULT_LISTEN_QUEUE_SIZE);

    //
    // Create global domain socket 
    //
    static socket_t*  create_global(char const* address,
				   int listen_queue_size = 
				       DEFAULT_LISTEN_QUEUE_SIZE);

    virtual ~socket_t() {} 
    socket_t() { state = ss_close; }

  protected:
    enum { ss_open, ss_shutdown, ss_close } state;
};

// 
// Return current host name + identifier of current process
//
extern char const* get_process_name(); 

#endif



