//-< REFS.H >--------------------------------------------------------*--------*
// GOODS                     Version 1.0         (c) 1997  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
//                                                                   *  /  \  *
//                          Created:     23-Feb-97    K.A. Knizhnik  * / [] \ *
//                          Last update: 25-Sep-97    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Smart object references templates
//-------------------------------------------------------------------*--------*

#ifndef __REFS_H__
#define __REFS_H__

#include "object.h"

class object_reference { 
    friend class database;
  public: 
    hnd_t get_handle() const { return hnd; }

  protected:
    hnd_t hnd;
    
    void unlink() { 
	object_handle::remove_reference(hnd); 
    }
    void link() { 
	if (hnd != 0) { 
	    hnd->access += 1;
	    if (!IS_VALID_OBJECT(hnd->obj)) { 
		internal_assert(hnd->storage != NULL); 
		hnd->storage->load(hnd);
                internal_assert(IS_VALID_OBJECT(hnd->obj));
	    }
        }
    }	
    object_reference(hnd_t hnd) { 
	object_monitor::lock_global();
        this->hnd = hnd; 
	link();
    }
    object_reference() { 
	hnd = 0; 
    }
    ~object_reference() { 
	unlink(); 
	object_monitor::unlock_global();
    }
};


template<class T>
class read_access : public object_reference { 
  private: 
    object* obj; 
  public:
    T const* operator ->() { 
	return (T const*)obj; 
    }
    read_access(hnd_t hnd) : object_reference(hnd) {
        hnd->obj->mop->begin_read(hnd); 
	// object can be reloaded by begin_read
	obj = hnd->obj;
	object_monitor::unlock_global(); 
    }
    read_access(read_access const& ra) : object_reference(ra.hnd) {
	obj = ra.obj;
	obj->mop->begin_read(hnd); 
	object_monitor::unlock_global(); 
    }
    ~read_access() { 
	object_monitor::lock_global();
        // object can be changed by become operator
	hnd->obj->mop->end_read(hnd); 
    } 
};


template<class T>
class write_access : public object_reference { 
  private: 
    object* obj; 
  public:
    T* operator ->() { 
	return (T*)obj; 
    }
    write_access(hnd_t hnd) : object_reference(hnd) {
	hnd->obj->mop->begin_write(hnd); 
	// object can be reloaded by begin_write
	obj = hnd->obj;
	object_monitor::unlock_global(); 
    }
    write_access(write_access const& wa) : object_reference(wa.hnd) {
	obj = wa.obj;
	obj->mop->begin_write(hnd); 
	object_monitor::unlock_global(); 
    }
    ~write_access() { 
	object_monitor::lock_global();
        // object can be changed by become operator
	hnd->obj->mop->end_write(hnd); 
    } 
};


template<class T>
class ref : public object_reference { 
  public:
    inline read_access<T> operator->() const { 
	assert(hnd != 0);
	return read_access<T>(hnd);
    }
    inline friend write_access<T> modify(ref const& r) { 
	assert(r.hnd != 0);
	return write_access<T>(r.hnd); 
    }  
    inline friend write_access<T> modify(T const* p) { 
	assert(p != NULL);
	return write_access<T>(((object*)p)->get_handle()); 
    }  

    inline boolean operator==(object_reference const& r) const { 
	return hnd == r.get_handle();
    }

    inline boolean operator!=(object_reference const& r) const { 
	return hnd != r.get_handle();
    }

    inline boolean operator==(T const* p) const { 
	return p ? (hnd == ((object*)p)->get_handle()) : (hnd == 0);
    }

    inline boolean operator!=(T const* p) const { 
	return p ? (hnd != ((object*)p)->get_handle()) : (hnd != 0);
    }

    inline boolean is_nil() const { return hnd == 0; }

    inline void operator=(ref const& r) { 
	object_monitor::lock_global(); 
	if (r.hnd != hnd) { 
	    unlink();
	    hnd = r.hnd;
	    link();
	}
	object_monitor::unlock_global(); 
    }
    
#if !defined(__GNUC__) 
    // EGCS produce warning for friend functions in template with -Wall
    friend class_descriptor& classof(T const*);
#endif

    inline void operator=(object_reference const& r) { 
#if defined(__GNUC__)
	extern class_descriptor& classof(T const*); 
#endif
	object_monitor::lock_global(); 
	if (r.get_handle() != hnd) { 
	    unlink();
	    hnd = r.get_handle();
	    link();
	    assert(hnd == 0 || classof((T const*)0).is_superclass_for(hnd)); 
	}
	object_monitor::unlock_global(); 
    }
 
    inline void operator=(T const* p) { 
	object_monitor::lock_global(); 
	unlink();
	if (p == NULL) { 
	    hnd = 0;
	} else { 
	    hnd = ((object*)p)->get_handle();
	    link();
	}
	object_monitor::unlock_global(); 
    }

    ref(ref const& r) : object_reference(r.hnd) { 
	object_monitor::unlock_global(); 
    }

    ref(object_reference const& r) : object_reference(r.get_handle()) { 
#if defined(__GNUC__)
	extern class_descriptor& classof(T const*); 
#endif
	assert(hnd == 0 || classof((T const*)0).is_superclass_for(hnd)); 
	object_monitor::unlock_global(); 
    }

    ref(T const* p) { 
	if (p != NULL) { 
	    object_monitor::lock_global(); 
	    hnd = ((object*)p)->get_handle();
	    link();
	    object_monitor::unlock_global(); 
	}
    }
    
    ref() {}

    ~ref() { object_monitor::lock_global(); }
};


#endif
