//-< PROTOCOL.CXX >--------------------------------------------------*--------*
// GOODS                     Version 1.0         (c) 1997  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
//                                                                   *  /  \  *
//                          Created:      7-Jan-97    K.A. Knizhnik  * / [] \ *
//                          Last update: 17-May-97    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// This file defines protocol of client-server and server-server communication
//-------------------------------------------------------------------*--------*

#include "stdinc.h"
#ifdef _WIN32
#pragma hdrstop
#endif
#include "protocol.h"

void dbs_field_descriptor::pack()
{ 
    pack2(type);
    pack2(name);
    pack4(size);
    pack4(n_items);
    pack4(next);
}

void dbs_field_descriptor::unpack()
{ 
    unpack2(type);
    unpack2(name);
    unpack4(size);
    unpack4(n_items);
    unpack4(next);
}

boolean dbs_class_descriptor::operator==(dbs_class_descriptor const& desc) const
{
    size_t this_size = get_size();
    size_t other_size = desc.get_size();
    return this_size == other_size && memcmp(this, &desc, this_size) == 0;
}

dbs_class_descriptor* dbs_class_descriptor::unpack()
{
    unpack4(fixed_size); 
    unpack4(varying_size); 
    unpack4(n_fixed_references); 
    unpack4(n_varying_references);
    unpack4(n_fields);
    unpack4(total_names_size);
    
    for (int i = n_fields; --i >= 0; fields[i].unpack());
    return this;
}

dbs_class_descriptor* dbs_class_descriptor::pack()
{
    for (int i = n_fields; --i >= 0; fields[i].pack());
    pack4(fixed_size); 
    pack4(varying_size); 
    pack4(n_fixed_references); 
    pack4(n_varying_references);
    pack4(n_fields);
    pack4(total_names_size);
    return this;
}


dbs_class_descriptor* dbs_class_descriptor::clone()
{
    size_t size = get_size();
    dbs_class_descriptor* desc = new (size) dbs_class_descriptor;
    memcpy(desc, this, size);
    return desc;
}
