//-< LARGEDB.CXX >---------------------------------------------------*--------*
// GOODS                     Version 1.0         (c) 1997  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
//                                                                   *  /  \  *
//                          Created:      4-Nov-98    K.A. Knizhnik  * / [] \ *
//                          Last update:  4-Nov-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Test of large database performance
//-------------------------------------------------------------------*--------*

#include "goods.h"
#include "dbscls.h"

#define N_RECORDS   1000000
#define RECORD_SIZE 100

class record : public object { 
  public: 
    ref<set_member> key;
    char            data[RECORD_SIZE];

    METACLASS_DECLARATIONS(record, object);

    record(const char* key_str, int key_len) : object(self_class) { 
	key = set_member::create(this, key_str, key_len);
    }
};

class wood : public object { 
  public: 
    ref<B_tree> tree;
    
    void initialize() const { 
	if (is_abstract_root()) { 
	    ref<wood> root = this;
	    modify(root)->become(new wood());
	} 
    }

    METACLASS_DECLARATIONS(wood, object);

  protected: 
    wood() : object(self_class) { 
	tree = B_tree::create(this); 
    }
};
    

field_descriptor& record::describe_components()
{
    return FIELD(key), ARRAY(data);
}

field_descriptor& wood::describe_components()
{
    return FIELD(tree);
}

REGISTER(wood, object, pessimistic_repeatable_read_scheme);
REGISTER(record, object, optimistic_scheme);

int main() 
{
    database db;
    task::initialize(task::normal_stack);

    if (db.open("large.cfg")) { 
	ref<wood> root;
	db.get_root(root);
        root->initialize();
	ref<B_tree> tree = root->tree;
	time_t start = time(NULL), last = start, curr;
	nat8 key = 1998;
	for (int i = 0, j = 0, k = 0, step = 100; i < N_RECORDS; i++) { 
	    key = (3141592621u*key + 2718281829u) % 1000000007u;
	    record* rec = new record((char*)&key, sizeof key);
	    modify(tree)->insert(rec->key);
	    if (++j == step) {  
		curr = time(NULL);
		k += j;
		j = 0;
		if (curr != last) { 
		    printf("Height %d, %d records, %.3f records per second (%.3f for last %d)   \r", 
			   tree->get_height(), i+1, (double)(i+1) / (curr - start), 
			   (double)k / (curr - last), k);
		    k = 0;
		    last = curr;
		} else { 
		    step *= 10;
		}
	    }
	}
	curr = time(NULL);
	printf("\nEllapsed time %d for %d records insertion (%.2f records per second)\n", 
	       int(curr-start), N_RECORDS, (double)N_RECORDS / (curr-start)); 
	tree->ok();
	db.close();
	return EXIT_SUCCESS;
    } else { 
	console::output("Failed to open database\n");
	return EXIT_FAILURE;
    }
}
