//-< SetOwner.java >-------------------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// GOODS Persistent Class Library                                    *  /  \  *
//                          Created:     15-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 15-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Set without explicit order of members
//-------------------------------------------------------------------*--------*

package goodslib;
import  goodsjpi.*;

public class SetOwner extends Persistent {
    protected SetMember first;
    protected SetMember last;
    protected int       nMembers;

    public SetMember getFirst() { return first; }
    public SetMember getLast() { return last; }
    public int       getNumberOfMembers() { return nMembers; }

    public synchronized void removeFirst() {
	first.owner = null;
	if ((first = first.next) == null) { 
	    last = null;
	}
	nMembers -= 1;
    }

    public synchronized void removeLast() { 
	last.owner = null;
	if ((last = last.prev) == null) { 
	    first = null;
	}
	nMembers -= 1;
    }

    public synchronized void remove(SetMember mbr) { 
	Assert.that(mbr.owner == this);
	mbr.owner = null;
	if (mbr == first) { 
	    first = first.next;
	} else { 
	    mbr.prev.next = mbr.next;
	}
	if (mbr == last) { 
	    last = last.prev;
	} else { 
	    mbr.next.prev = mbr.prev;
	}
	nMembers -= 1;
    }

    public synchronized void insertFirst(SetMember mbr) {
	Assert.that(mbr.owner == null);
	if (first != null) { 
	    first.prev = mbr;
	} else { 
	    last = mbr;
	}
	mbr.next = first;
	mbr.prev = null;
	mbr.owner = this;
	first = mbr;
	nMembers += 1;
    }

    public synchronized void insertLast(SetMember mbr) { 
	Assert.that(mbr.owner == null);
	if (last != null) { 
	    last.next = mbr;
	} else { 
	    first = mbr;
	}
	mbr.prev = last;
	mbr.next = null;
	mbr.owner = this;
	last = mbr;
	nMembers += 1;
    }

    public synchronized void insertAfter(SetMember after, SetMember mbr) { 
	Assert.that(after.owner == this && mbr.owner == null);
	mbr.next = after.next;
	mbr.prev = after;
	mbr.owner = this;
	after.next = mbr;
	if (after == last) {
	    last = mbr;
	} else {
	    mbr.next.prev = mbr;
	}
	nMembers += 1;
    }

    public synchronized void insertBefore(SetMember before, SetMember mbr) { 
	Assert.that(before.owner == this && mbr.owner == null);
	mbr.prev = before.prev;
	mbr.next = before;
	mbr.owner = this;
	before.prev = mbr;
	if (before == first) {
	    first = mbr;
	} else {
	    mbr.prev.next = mbr;
	}
	nMembers += 1;
    }

    public synchronized SetMember find(Object key) { 
	for (SetMember mbr = first; mbr != null; mbr = mbr.next) { 
	    if (mbr.compareKey(key) == 0) { 
		return mbr;
	    }
	}
	return null;
    }
}



