//-< SetMemberKey.java >---------------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// GOODS Persistent Class Library                                    *  /  \  *
//                          Created:     17-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 17-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Link to the member of a set with specified key
//-------------------------------------------------------------------*--------*

package goodslib;
import  goodsjpi.*;

public class SetMemberKey extends SetMemberRef {
    private char[] key;

    public String getKey() { 
	return new String(key);
    }
    
    public int compare(Ordered mbr) { 
	return -obj.compareKey(new String(key));
    }

    public int compareKey(Object keystr) {
	String s = (String)keystr;
        int length = s.length();
	int n = length < key.length ? length : key.length;

	for (int i = 0; i < n; i++) { 
  	    if (key[i] != s.charAt(i)) { 
	        return key[i] - s.charAt(i);
	    }
	}
	return key.length - length;
    }
    
    public SetMemberKey(Ordered obj, String key) { 
	super(obj);
	this.key = key.toCharArray();
    }
}



