//-< QueryIterator.java >--------------------------------------------*--------*
// GOODS                      Version 2.04       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// GOODS Persistent Class Library                                    *  /  \  *
//                          Created:      5-Mar-99    K.A. Knizhnik  * / [] \ *
//                          Last update:  5-Mar-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// JSQL query iterator abstraction
//-------------------------------------------------------------------*--------*

package goodslib;

public interface QueryIterator {
    /**
     * Get first object.
     *
     * @return first object or <code>null</code> if there are no object to 
     *  search.
     */
    public Object getFirst();


    /**
     * Get next object.
     * 
     * @param prevObj reference returned by previous call of 
     *  <code>getNext</code> or <code>getFirst</code>
     * @param prevIndex index of previous object (starting from 0 for first 
     *  object)
     * @return next object or <code>null</code> if there are no more objects
     */
    public Object getNext(Object prevObj, int prevIndex);
    
    /**
     * Try to use index to locate object by unique primary key.
     * 
     * @param primaryKey name of prinmary key field. This files should be 
     *  unique among all searched object.
     * @param keyValue key value
     * @return object with specified value of primary key or <code>null</code>
     *  if object was not found.
     * @exception NoIndexException if there is no index for this field
     */
    public Object getByKey(String primaryKey, Object keyValue) 
    throws NoIndexException;
}
