//-< OrderedSetOwner.java >------------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// GOODS Persistent Class Library                                    *  /  \  *
//                          Created:     15-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 15-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Ordered set 
//-------------------------------------------------------------------*--------*

package goodslib;
import  goodsjpi.*;

public class OrderedSetOwner extends SetOwner {

    public synchronized void insertFirst(SetMember newMbr) {
	Assert.that(newMbr.owner == null);
	for (SetMember mbr = first; mbr != null; mbr = mbr.next) { 
	    if (newMbr.compare(mbr) <= 0) { 
		super.insertBefore(mbr, newMbr);
		return;
	    }
	}
	super.insertLast(newMbr);
    }

    public synchronized void insertLast(SetMember newMbr) {
	Assert.that(newMbr.owner == null);
	for (SetMember mbr = last; mbr != null; mbr = mbr.prev) { 
	    if (newMbr.compare(mbr) >= 0) { 
		super.insertAfter(mbr, newMbr);
		return;
	    }
	}
	super.insertFirst(newMbr);
    }

    public synchronized void insertBefore(SetMember before, SetMember mbr) {
	Assert.that(before.owner == this && mbr.owner == null);
	Assert.that(mbr.compare(before) <= 0);
	while ((before = before.prev) != null) { 
	    if (mbr.compare(before) >= 0) { 
		super.insertAfter(before, mbr);
		return;
	    }
	}
	super.insertFirst(mbr);
    }

    public synchronized void insertAfter(SetMember after, SetMember mbr) {
	Assert.that(after.owner == this && mbr.owner == null);
	Assert.that(mbr.compare(after) >= 0);
	while ((after = after.next) != null) { 
	    if (mbr.compare(after) <= 0) { 
		super.insertBefore(after, mbr);
		return;
	    }
	}
	super.insertLast(mbr);
    }

    public synchronized void insert(SetMember mbr) {
	insertFirst(mbr);
    }

    public synchronized SetMember find(Object key) { 
	for (SetMember mbr = first; mbr != null; mbr = mbr.next) { 
	    int diff = mbr.compareKey(key);
	    if (diff == 0) { 
		return mbr;
	    } else if (diff > 0) { 
		return null;
	    }
	}
	return null;
    }

    public synchronized SetMember findGreaterOrEqual(Object key) { 
	SetMember mbr;
	for (mbr=first; mbr != null && mbr.compareKey(key) < 0; mbr=mbr.next);
	return mbr;
    }
}



