//-< ObjectClosure.java >--------------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// GOODS Persistent Class Library                                    *  /  \  *
//                          Created:     20-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 20-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Persistent class for storing closure of serialized transient objects
//-------------------------------------------------------------------*--------*

package goodslib;
import  goodsjpi.*;

import java.io.*;

/** 
 * This class can be used to save in persistent storage cluster of 
 * transient Java objects using serialization mecahnism. Class
 * java.io.ObjectOutputStream is used to pack all objects reachable from
 * some specified root object into stream of bytes. Data is stored in 
 * GOODS persistent object as array of bytes. It can be restored lately
 * by java.io.ObjectInputStream (classes of all packed objects should be
 * available in application). 
 */
public class ObjectClosure extends Persistent { 
    protected byte[] buf;
   
    /** 
     * Pack objects into array of bytes to be placed in storage.
     * All objects accessible by refernces from root objects will be placed
     * in this object closure. 
     */
    public synchronized void store(Object root) { 
	try { 
	    ByteArrayOutputStream out = new ByteArrayOutputStream();
	    ObjectOutputStream clu = new ObjectOutputStream(out);
	    clu.writeObject(root);
	    clu.close();
	    buf = out.toByteArray();
	} catch (Exception x) { 
	    throw new Error(x.getMessage());
	}
    }

    /**
     * Extract objects from object closure and returns reference to root object
     * and return reference to root object. After been extracted from the 
     * closure, these objects will have no differenecs with normal Java
     * transparent objects. 
     */
    public synchronized Object extract() { 
	try { 
	    ByteArrayInputStream input = new ByteArrayInputStream(buf);
	    ObjectInputStream in = new ObjectInputStream(input);
	    return in.readObject();
	} catch (Exception x) { 
	    throw new Error(x.getMessage());
	}
    }

    /**
     * Create new instance of object closure given specified root object.
     */
    public ObjectClosure(Object root) { 
	store(root);
    }
}
