//-< ClassLibrary.java >---------------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// GOODS Persistent Class Library                                    *  /  \  *
//                          Created:     11-Nov-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 11-Nov-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Class providing load and store of classes from/to database
//-------------------------------------------------------------------*--------*

package goodslib;

import goodsjpi.*;
import java.io.*;
import java.util.Hashtable;

public class ClassLibrary extends HashTable { 
    /**
     * Store class with specified name in the storage. 
     * Parameter <TT>className</TT> should be fully qualified Java class name 
     * separated by period character. File name of the class file is produced
     * by replacing period character with OS file separator symbol and 
     * appending suffix ".class". Then contents of the file is placed in GOODS
     * storage and reference to it is inserted in the hash table. This class
     * can throw <TT>IOException</TT> if it fails to read the class file data. 
     */
    public void storeClass(String className) throws IOException { 
	String fileName = className.replace('.', File.separatorChar)+".class";
	File f = new File(fileName); 
	int length = (int)f.length();
	byte b[] = new byte[length];
	FileInputStream in = new FileInputStream(f);
	int res = in.read(b);
	Assert.that(res == length);
	in.close();
	put(className, new ArrayOfByte(b));
    }

    /** 
     * Load class from the storage. The name parameter should be the same as 
     * in correspondent <TT>storeClass</TT> method. This name is used as 
     * search key in hash table with stored classes. 
     * Class is loaded and resolved using special persistent class loader and
     * pointer to created <TT>Class</TT> object is returned. If no class
     * definition was found in the hash table, than <TT>null</TT> is returned.
     */

    public synchronized Class loadClass(String name) { 
	if (loader == null) { 
	    loader = new PersistentClassLoader(this);
	}
	try { 
	    return loader.loadClass(name, true);
	} catch (ClassNotFoundException x) { 
	    return null;
	}
    }

    protected transient PersistentClassLoader loader;
}
    


class PersistentClassLoader extends ClassLoader { 
    static Hashtable loadedClasses = new Hashtable();
    ClassLibrary library;

    public Class loadClass(String name, boolean resolve) 
    throws ClassNotFoundException 
    {
	Class cls = (Class)loadedClasses.get(name);
	if (cls == null) {
	    try { 
		cls = findSystemClass(name);
		if (cls != null) { 
		    return cls;
		}
	    } catch(ClassNotFoundException x) {}

	    ArrayOfByte b = (ArrayOfByte)library.get(name); 
	    if (b == null) { 
		return null;
	    }
	    byte[] bytes = b.asArray();
	    cls = defineClass(name, bytes, 0, bytes.length);		
	    loadedClasses.put(name, cls);
	}
	if (resolve) { 
	    resolveClass(cls);
	} 
	return cls;
    }

    PersistentClassLoader(ClassLibrary lib) { 
	library = lib;
    }
}
