//-< Blob.java >-----------------------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// GOODS Persistent Class Library                                    *  /  \  *
//                          Created:     23-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 23-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Binary Large OBject with concurrent fetching from the storage 
//-------------------------------------------------------------------*--------*

package goodslib;
import  goodsjpi.*;

/**
 * Binary large object class. This class can be used as base for
 * creating multimedia or text objects with large size and sequential 
 * access. This class provide functionality for incremental object
 * loading by parallel task. 
 */

public class Blob extends Persistent { 
    protected Blob next;
    protected Blob last;
    protected byte data[];
    
    /**
     * This method is called by 'play'  method for each part of blob
     * object within conext of current task. If this method returns False 
     * preloading process is terminated. 
     */
    public boolean handle() {
	return false; // default implementation do nothing
    }
    /**
     * Default implementation of this method just extracts all parts of 
     * blob from database and calls handle method for each part.
     */
    public synchronized void play() { 
	if (next == null) { 
	    handle(); // that is all
	} else { 
	    BlobFetchThread fetch = new BlobFetchThread(this);
	    fetch.start();
	    Blob curr = this;
	    try { 
		while (curr.handle()) { 
		    if (curr.next != null) { 
			wait();
			fetch.next();
			curr = curr.next;
		    } else { 
			return;
		    }
		}
		if (curr.next != null) { 
		    fetch.cancel = true;
		    wait();
		    fetch.next();
		}
		fetch.join();
	    } catch(InterruptedException x) { 
		throw new Error(x.getMessage());
	    }
	}
    }

    protected synchronized void fetched() { 
	notify();
    }

    /**
     * Append new blob object at the end of blob objects chain.
     */
    public synchronized void append(Blob bp) { 
	last.next = bp; 
	last = bp;
    }

    public Blob(int partSize) { 
	last = this;
	data = new byte[partSize];
    }

    public Blob(byte[] buf) { 
	last = this;
	data = buf;
    }
}

class BlobFetchThread extends Thread { 
    volatile boolean cancel;
    Blob             chain;

    public synchronized void run() { 
	Blob head = chain; 
	Blob curr = head.next; 

	do { 
	    curr = curr.next;
	    head.fetched();
	    try { 
		wait();
	    } catch(Exception x) { 
		throw new Error(x.getMessage());
	    }
	} while (!cancel && curr != null);
    }
    
    synchronized void next() { 
	notify();
    }

    BlobFetchThread(Blob b) { 
	chain = b;
    }
}
  
