//-< ArrayOfShort.java >----------------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// GOODS Persistent Class Library                                    *  /  \  *
//                          Created:      1-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 18-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Dynamic array of shorts
//-------------------------------------------------------------------*--------*

package goodslib;
import  goodsjpi.*;

public class ArrayOfShort extends AnyArray { 
    protected short[] array;

    public synchronized void putAt(int index, short value) { 
        if (index < 0 || index >= used) { 
	    throw new ArrayIndexOutOfBoundsException(index);
	}
	Metaobject.modify();
	array[index] = value;
    }

    public synchronized short getAt(int index) { 
        if (index < 0 || index >= used) { 
	    throw new ArrayIndexOutOfBoundsException(index);
	}
	return array[index];
    }
    

    public synchronized void changeSize(int newSize) { 
        if (newSize < 0) { 
	    throw new ArrayIndexOutOfBoundsException(newSize);
	}
	int allocated = array.length;
	if (newSize > allocated) {
	    allocated = (allocated*2 > newSize) ? allocated*2 : newSize;
	    short[] newArray = new short[allocated];
	    System.arraycopy(array, 0, newArray, 0, used);
	    array = newArray;
	} else if (newSize < used) { 
	    for (int i = used; --i >= newSize; array[i] = 0);
	} 
	used = newSize;
    }


    public synchronized void insert(int index, int count, short value) { 
	if (count < 0) { 
	    throw new ArrayIndexOutOfBoundsException(count);
	} else if (index < 0 || index > used) { 
	    throw new ArrayIndexOutOfBoundsException(index);
	}
	changeSize(used+count);
	System.arraycopy(array, index, array, index+count, used-index-count);
	while (--count >= 0) { 
	    array[index++] = value;
	}
    }

    public synchronized void remove(int index, int count) {
	if (count < 0) { 
	    throw new ArrayIndexOutOfBoundsException(count);
	} else if (index < 0) { 
	    throw new ArrayIndexOutOfBoundsException(index);
	} else if (index+count > used) { 
	    throw new ArrayIndexOutOfBoundsException(index+count);
	}
	System.arraycopy(array, index+count, array, index, used-count-index);
	changeSize(used-count);
    }


    public synchronized void push(short value) { 
	changeSize(used+1);
	array[used-1] = value;
    }

    public synchronized short pop() { 
	if (used == 0) { 
	    throw new ArrayIndexOutOfBoundsException(0);
	}
	short value = array[--used];
	array[used] = 0;
	return value;
    }

    public synchronized short top() { 
	if (used == 0) { 
	    throw new ArrayIndexOutOfBoundsException(0);
	}
	return array[used-1];
    }


    public synchronized void append(short[] tail) { 
        int size = used;
        changeSize(size + tail.length);
	System.arraycopy(tail, 0, array, size, tail.length);
    }

    public synchronized short[] asArray() { 
        short[] arr = new short[used];
	System.arraycopy(array, 0, arr, 0, used);
        return arr;
    }
  
    public synchronized void copy(int dstIndex, short[] src, int srcIndex, 
				  int count) 
    { 
        if (dstIndex < 0) { 
	    throw new ArrayIndexOutOfBoundsException(dstIndex);
	} else if (dstIndex+count > used) { 
	    throw new ArrayIndexOutOfBoundsException(dstIndex+count);
	} 
	Metaobject.modify();
	System.arraycopy(src, srcIndex, array, dstIndex, count);
    }

    public synchronized int indexOf(short val) { 
        for (int i = 0; i < used; i++) { 
	    if (array[i] == val) { 
		return i;
	    }
	}
	return -1;
    }

    public synchronized int lastIndexOf(short val) { 
        for (int i = used; --i >= 0;) { 
	    if (array[i] == val) { 
		return i;
	    }
	}
	return -1;
    }

    public ArrayOfShort(int size) {
	this(size, size == 0 ? 16 : size);
    }

    public ArrayOfShort(int size, int allocatedSize) {
	Assert.that(size <= allocatedSize);
	array = new short[allocatedSize];
	used = size;
    }
    
    public ArrayOfShort(short[] src) { 
	int length = src.length;
	array = new short[length];
	used = length;
	System.arraycopy(src, 0, array, 0, length);
    }
}



