//-< ArrayOfInt.java >-----------------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// GOODS Persistent Class Library                                    *  /  \  *
//                          Created:      1-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 18-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Dynamic array of integers
//-------------------------------------------------------------------*--------*

package goodslib;
import  goodsjpi.*;

public class ArrayOfInt extends AnyArray { 
    protected int[] array;

    public synchronized void putAt(int index, int value) { 
        if (index < 0 || index >= used) { 
	    throw new ArrayIndexOutOfBoundsException(index);
	}
	Metaobject.modify();
	array[index] = value;
    }

    public synchronized int getAt(int index) { 
        if (index < 0 || index >= used) { 
	    throw new ArrayIndexOutOfBoundsException(index);
	}
	return array[index];
    }
    

    public synchronized void changeSize(int newSize) { 
        if (newSize < 0) { 
	    throw new ArrayIndexOutOfBoundsException(newSize);
	}
	int allocated = array.length;
	if (newSize > allocated) {
	    allocated = (allocated*2 > newSize) ? allocated*2 : newSize;
	    int [] newArray = new int [allocated];
	    System.arraycopy(array, 0, newArray, 0, used);
	    array = newArray;
	} else if (newSize < used) { 
	    for (int i = used; --i >= newSize; array[i] = 0);
	} 
	used = newSize;
    }


    public synchronized void insert(int index, int count, int value) { 
	if (count < 0) { 
	    throw new ArrayIndexOutOfBoundsException(count);
	} else if (index < 0 || index > used) { 
	    throw new ArrayIndexOutOfBoundsException(index);
	}
	changeSize(used+count);
	System.arraycopy(array, index, array, index+count, used-index-count);
	while (--count >= 0) { 
	    array[index++] = value;
	}
    }

    public synchronized void remove(int index, int count) {
	if (count < 0) { 
	    throw new ArrayIndexOutOfBoundsException(count);
	} else if (index < 0) { 
	    throw new ArrayIndexOutOfBoundsException(index);
	} else if (index+count > used) { 
	    throw new ArrayIndexOutOfBoundsException(index+count);
	}
	System.arraycopy(array, index+count, array, index, used-count-index);
	changeSize(used-count);
    }


    public synchronized void push(int value) { 
	changeSize(used+1);
	array[used-1] = value;
    }

    public synchronized int pop() { 
	if (used == 0) { 
	    throw new ArrayIndexOutOfBoundsException(0);
	}
	int value = array[--used];
	array[used] = 0;
	return value;
    }

    public synchronized int top() { 
	if (used == 0) { 
	    throw new ArrayIndexOutOfBoundsException(0);
	}
	return array[used-1];
    }


    public synchronized void append(int[] tail) { 
        int size = used;
        changeSize(size + tail.length);
	System.arraycopy(tail, 0, array, size, tail.length);
    }


    public synchronized int[] asArray() { 
        int[] arr = new int[used];
	System.arraycopy(array, 0, arr, 0, used);
        return arr;
    }
  
    public synchronized void copy(int dstIndex, int [] src, int srcIndex, 
				  int count) 
    { 
        if (dstIndex < 0) { 
	    throw new ArrayIndexOutOfBoundsException(dstIndex);
	} else if (dstIndex+count > used) { 
	    throw new ArrayIndexOutOfBoundsException(dstIndex+count);
	} 
	Metaobject.modify();
	System.arraycopy(src, srcIndex, array, dstIndex, count);
    }

    public synchronized int indexOf(int val) { 
        for (int i = 0; i < used; i++) { 
	    if (array[i] == val) { 
		return i;
	    }
	}
	return -1;
    }

    public synchronized int lastIndexOf(int val) { 
        for (int i = used; --i >= 0;) { 
	    if (array[i] == val) { 
		return i;
	    }
	}
	return -1;
    }

    public ArrayOfInt(int size) {
	this(size, size == 0 ? 16 : size);
    }

    public ArrayOfInt(int size, int allocatedSize) {
	Assert.that(size <= allocatedSize);
	array = new int[allocatedSize];
	used = size;
    }
    
    public ArrayOfInt(int[] src) { 
	int length = src.length;
	array = new int[length];
	used = length;
	System.arraycopy(src, 0, array, 0, length);
    }
}


