//-< ArrayOfDouble.java >--------------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// GOODS Persistent Class Library                                    *  /  \  *
//                          Created:      1-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 18-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Dynamic array of doubles
//-------------------------------------------------------------------*--------*

package goodslib;
import  goodsjpi.*;

public class ArrayOfDouble extends AnyArray { 
    protected double[] array;

    public synchronized void putAt(int index, double value) { 
        if (index < 0 || index >= used) { 
	    throw new ArrayIndexOutOfBoundsException(index);
	}
	Metaobject.modify();	
	array[index] = value;
    }

    public synchronized double getAt(int index) { 
        if (index < 0 || index >= used) { 
	    throw new ArrayIndexOutOfBoundsException(index);
	}
	return array[index];
    }
    

    public synchronized void changeSize(int newSize) { 
        if (newSize < 0) { 
	    throw new ArrayIndexOutOfBoundsException(newSize);
	}
	int allocated = array.length;
	if (newSize > allocated) {
	    allocated = (allocated*2 > newSize) ? allocated*2 : newSize;
	    double[] newArray = new double[allocated];
	    System.arraycopy(array, 0, newArray, 0, used);
	    array = newArray;
	} else if (newSize < used) { 
	    for (int i = used; --i >= newSize; array[i] = 0.0);
	} 
	used = newSize;
    }


    public synchronized void insert(int index, int count, double value) { 
	if (count < 0) { 
	    throw new ArrayIndexOutOfBoundsException(count);
	} else if (index < 0 || index > used) { 
	    throw new ArrayIndexOutOfBoundsException(index);
	}
	changeSize(used+count);
	System.arraycopy(array, index, array, index+count, used-index-count);
	while (--count >= 0) { 
	    array[index++] = value;
	}
    }

    public synchronized void remove(int index, int count) {
	if (count < 0) { 
	    throw new ArrayIndexOutOfBoundsException(count);
	} else if (index < 0) { 
	    throw new ArrayIndexOutOfBoundsException(index);
	} else if (index+count > used) { 
	    throw new ArrayIndexOutOfBoundsException(index+count);
	}
	System.arraycopy(array, index+count, array, index, used-count-index);
	changeSize(used-count);
    }


    public synchronized void push(double value) { 
	changeSize(used+1);
	array[used-1] = value;
    }

    public synchronized double pop() { 
	if (used == 0) { 
	    throw new ArrayIndexOutOfBoundsException(0);
	}
	double value = array[--used];
	array[used] = 0.0;
	return value;
    }

    public synchronized double top() { 
	if (used == 0) { 
	    throw new ArrayIndexOutOfBoundsException(0);
	}
	return array[used-1];
    }


    public synchronized void append(double[] tail) { 
        int size = used;
        changeSize(size + tail.length);
	System.arraycopy(tail, 0, array, size, tail.length);
    }


    public synchronized double[] asArray() { 
        double[] arr = new double[used];
	System.arraycopy(array, 0, arr, 0, used);
        return arr;
    }
  
    public synchronized void copy(int dstIndex, double[] src, int srcIndex, 
				  int count) 
    { 
        if (dstIndex < 0) { 
	    throw new ArrayIndexOutOfBoundsException(dstIndex);
	} else if (dstIndex+count > used) { 
	    throw new ArrayIndexOutOfBoundsException(dstIndex+count);
	} 
	Metaobject.modify();
	System.arraycopy(src, srcIndex, array, dstIndex, count);
    }

    public synchronized int indexOf(double val) { 
        for (int i = 0; i < used; i++) { 
	    if (array[i] == val) { 
		return i;
	    }
	}
	return -1;
    }

    public synchronized int lastIndexOf(double val) { 
        for (int i = used; --i >= 0;) { 
	    if (array[i] == val) { 
		return i;
	    }
	}
	return -1;
    }

    public ArrayOfDouble(int size) {
	this(size, size == 0 ? 16 : size);
    }

    public ArrayOfDouble(int size, int allocatedSize) {
	Assert.that(size <= allocatedSize);
	array = new double[allocatedSize];
	used = size;
    }
    
    public ArrayOfDouble(double[] src) { 
	int length = src.length;
	array = new double[length];
	used = length;
	System.arraycopy(src, 0, array, 0, length);
    }
}



