//-< ArrayOfChar.java >----------------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// GOODS Persistent Class Library                                    *  /  \  *
//                          Created:      1-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 15-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Dynamic array of chars
//-------------------------------------------------------------------*--------*

package goodslib;
import  goodsjpi.*;

public class ArrayOfChar extends AnyArray { 
    protected char[] array;

    public synchronized void putAt(int index, char value) { 
        if (index < 0 || index >= used) { 
	    throw new ArrayIndexOutOfBoundsException(index);
	}
	Metaobject.modify();
	array[index] = value;
    }

    public synchronized char getAt(int index) { 
        if (index < 0 || index >= used) { 
	    throw new ArrayIndexOutOfBoundsException(index);
	}
	return array[index];
    }
    

    public synchronized void changeSize(int newSize) { 
        if (newSize < 0) { 
	    throw new ArrayIndexOutOfBoundsException(newSize);
	}
        int allocated = array.length;
	if (newSize > allocated) {
	    allocated = (allocated*2 > newSize) ? allocated*2 : newSize;
	    char[] newArray = new char[allocated];
	    System.arraycopy(array, 0, newArray, 0, used);
	    array = newArray;
	} else if (newSize < used) { 
	    for (int i = used; --i >= newSize; array[i] = 0);
	}
	used = newSize;
    }


    public synchronized void insert(int index, int count, char value) { 
	if (count < 0) { 
	    throw new ArrayIndexOutOfBoundsException(count);
	} else if (index < 0 || index > used) { 
	    throw new ArrayIndexOutOfBoundsException(index);
	}
	changeSize(used+count);
	System.arraycopy(array, index, array, index+count, used-index-count);
	while (--count >= 0) { 
	    array[index++] = value;
	}
    }

    public synchronized void remove(int index, int count) {
	if (count < 0) { 
	    throw new ArrayIndexOutOfBoundsException(count);
	} else if (index < 0) { 
	    throw new ArrayIndexOutOfBoundsException(index);
	} else if (index+count > used) { 
	    throw new ArrayIndexOutOfBoundsException(index+count);
	}
	System.arraycopy(array, index+count, array, index, used-count-index);
	changeSize(used-count);
    }


    public synchronized void push(char value) { 
	changeSize(used+1);
	array[used-1] = value;
    }

    public synchronized char pop() { 
	if (used == 0) { 
	    throw new ArrayIndexOutOfBoundsException(0);
	}
	char value = array[--used];
	array[used] = 0;
	return value;
    }

    public synchronized char top() { 
	if (used == 0) { 
	    throw new ArrayIndexOutOfBoundsException(0);
	}
	return array[used-1];
    }


    public synchronized void append(char[] tail) { 
        int size = used;
        changeSize(size + tail.length);
	System.arraycopy(tail, 0, array, size, tail.length);
    }

    public synchronized void append(String tail) { 
        int size = used;
	int length = tail.length();
        changeSize(size + length);
	tail.getChars(0, length, array, size);
    }

    public synchronized char[] asArray() { 
        char[] arr = new char[used];
	System.arraycopy(array, 0, arr, 0, used);
        return arr;
    }
    public synchronized String asString() { 
        return new String(array, 0, used);
    }
  
    public synchronized void copy(int dstIndex, char[] src, int srcIndex, 
				  int count) 
    { 
        if (dstIndex < 0) { 
	    throw new ArrayIndexOutOfBoundsException(dstIndex);
	} else if (dstIndex+count > used) { 
	    throw new ArrayIndexOutOfBoundsException(dstIndex+count);
	} 
	Metaobject.modify();
	System.arraycopy(src, srcIndex, array, dstIndex, count);
    }

    public synchronized int compare(String s) { 
        int len = s.length();
	int n = len < used ? len : used;

	for (int i = 0; i < n; i++) { 
  	    int diff = array[i] - s.charAt(i);
	    if (diff != 0) { 
	        return diff;
	    }
	}
	return used - len;
    }

    public synchronized int compare(ArrayOfChar a) { 
        int len = a.used;
	char[] s = a.array;
	int n = len < used ? len : used;

	for (int i = 0; i < n; i++) { 
  	    int diff = array[i] - s[i];
	    if (diff != 0) {
		return diff;
	    }
	}
	return used - len;
    }

    public synchronized int hashCode() {
	int h = 0;
	for (int i = 0, len = used; i < len; i++) { 
	    h = 31*h + array[i];
	}
	return h;
    }


    public synchronized boolean equals(Object obj) { 
	if (obj == this) {
	    return true;
	}
	if (obj == null) { 
	    return false;
	}
	if (obj instanceof String) { 
	    String s = (String)obj;
	    int len = s.length();
	    if (len != used) { 
		return false;
	    }
	    for (int i = 0; i < len; i++) { 
		if (array[i] != s.charAt(i)) { 
		    return false;
		}
	    }
	} else if (obj instanceof char[]) { 
	    char[] s = (char[])obj;
	    int len = s.length;
	    if (len != used) { 
		return false;
	    }
	    for (int i = 0; i < len; i++) { 
		if (array[i] != s[i]) { 
		    return false;
		}
	    }
	} else if (obj instanceof ArrayOfChar) { 
	    ArrayOfChar a = (ArrayOfChar)obj;
	    int len = a.used;
	    if (used != len) { 
		return false;
	    }
	    for (int i = 0; i < len; i++) { 
		if (array[i] != a.array[i]) { 
		    return false;
		}
	    }
	} else { 
	    return false;
	}
	return true;
    }


    public synchronized int indexOf(char ch) { 
        for (int i = 0; i < used; i++) { 
	    if (array[i] == ch) { 
		return i;
	    }
	}
	return -1;
    }

    public synchronized int lastIndexOf(char ch) { 
        for (int i = used; --i >= 0;) { 
	    if (array[i] == ch) { 
		return i;
	    }
	}
	return -1;
    }

    public ArrayOfChar(int size) {
	this(size, size == 0 ? 16 : size);
    }

    public ArrayOfChar(int size, int allocatedSize) {
	Assert.that(size <= allocatedSize);
	array = new char[allocatedSize];
	used = size;
    }
    
    public ArrayOfChar(char[] src) { 
	int length = src.length;
	array = new char[length];
	used = length;
	System.arraycopy(src, 0, array, 0, length);
    }

    public ArrayOfChar(String str) { 
	int length = str.length();
	array = new char[length];
	used = length;
	str.getChars(0, length, array, 0);
    }
}




