//-< WeakHashTable.java >--------------------------------------------*--------*
// GOODS                      Version 2.0        (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// Java Program Interface                                            *  /  \  *
//                          Created:     11-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 11-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Hash table based on weak pointers provided by JDK 1.2
//-------------------------------------------------------------------*--------*

package goodsjpi.weak;

import java.util.Hashtable;
import java.lang.ref.WeakReference;

public class WeakHashTable extends Hashtable { 
    public Object put(Object key, Object value) { 
	return super.put(key, new WeakReference(value));
    }
    public Object get(Object key) {
	Object obj = super.get(key);
	if (obj != null) { 
	    return ((WeakReference)obj).get();
	}
	return null;
    }
}
