//-< MsWeakHashTable.java >------------------------------------------*--------*
// GOODS                      Version 2.0        (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// Java Program Interface                                            *  /  \  *
//                          Created:     11-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 11-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// This is a temporary solution proiding weak hash table for Microsoft Java.
// To compile this file make sure that class path points to \WINNT\Java\Classes
//-------------------------------------------------------------------*--------*

package goodsjpi.weak;

import java.util.Hashtable;
import com.ms.vm.WeakReference;

public class MsWeakHashTable extends Hashtable { 
    public Object put(Object key, Object value) { 
	return super.put(key, new WeakReference(value));
    }

    public Object get(Object key) {
	Object obj = super.get(key);
	if (obj != null) { 
	    return ((WeakReference)obj).getReferent();
	}
	return null;
    }
}
