//-< Protocol.java >-------------------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// Java Program Interface                                            *  /  \  *
//                          Created:      1-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 10-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Description of client-server communication protocol
//-------------------------------------------------------------------*--------*

package goodsjpi;

class Protocol { 
    static final int RAW_CPID  = 0x00001;
    static final int ROOT_OPID = 0x10000;
    
    //
    // Object reference components
    //
    static final int ref_sid_offs  = 0;
    static final int ref_opid_offs = 2;

    static final int ref_size = 6;

    //
    // Offsets of object header fields
    //
    static final int hdr_flags_offs = 0;
    static final int hdr_opid_offs  = 4;
    static final int hdr_cpid_offs  = 8;
    static final int hdr_sid_offs   = 10;
    static final int hdr_size_offs  = 12;

    static final int hdr_size = 16;

    //
    // Types of object fields
    //
    static final int fld_structure = 0;
    static final int fld_reference = 1;
    static final int fld_signed_integer = 2;
    static final int fld_unsigned_integer = 3; 
    static final int fld_real = 4;
    static final int fld_string = 5;

    //
    // Field descriptor fields offsets
    //
    static final int fds_type_offs   = 0;
    static final int fds_name_offs   = 2;
    static final int fds_size_offs   = 4;
    static final int fds_nitems_offs = 8;
    static final int fds_next_offs   = 12;
    
    static final int fds_size = 16;

    //
    // Class descriptor fields offsets
    //
    static final int cds_fixed_size_offs       = 0;
    static final int cds_varying_size_offs     = 4;
    static final int cds_n_fixed_refs_offs     = 8;
    static final int cds_n_varying_refs_offs   = 12;
    static final int cds_n_fields_offs         = 16;
    static final int cds_total_names_size_offs = 20;

    static final int cds_header_size = 24;

    //
    // Lock request types
    //
    static final int lck_none      = 0; // No lock
    static final int lck_shared    = 1; // Prevent object from been modified or
                                        // exclusivly locked by other processes
    static final int lck_exclusive = 2; // Prevent object from been modified or
                             // locked (shared or exlusive) by other processes

    //
    // Lock attributes
    //
    static final int lckattr_wait   = 0;
    static final int lckattr_nowait = 1; // Lock request will not block, 
        // if granting lock is impossible, request will be immediately refused 

    //
    // Transaction object flags 
    //
    static final int tof_none      = 0;  
    static final int tof_update    = 1; // request to update object
    static final int tof_validate  = 2; // request to validate transaction 
	                                // object at server
    static final int tof_unlock    = 4; // request to unlock transaction object
	                                // at the end of transaction
    static final int tof_unlock_exl = 8;// request to release exclusive lock 
                                        // at the end of transaction
    //
    // load object flags
    //
    static final int lof_none     = 0;
    static final int lof_copy     = 1; // request another copy of object
    static final int lof_cluster  = 2; // enable sending cluster of objects


    // 
    // Command request codes
    // 
    static final byte cmd_load=0;      // client request object from server
    static final byte cmd_object=1;    // server sent object to client
    static final byte cmd_forget=2;    // client remove reference to object
    static final byte cmd_throw=3;     // client throw away instance of object
                                       // from the cache
    static final byte cmd_invalidate=4;// server inform client about object 
                                       // modification

    static final byte cmd_getclass=5;  // get class descriptor from server
    static final byte cmd_classdesc=6; // server send class descriptor to client

    static final byte cmd_putclass=7;  // register new class at server 
    static final byte cmd_classid=8;   // class identifier returned to client 

    static final byte cmd_modclass=9;  // modify existed class at server

    static final byte cmd_lock=10;     // request to server to lock object
    static final byte cmd_lockresult=11;// result of applying lock request 
    static final byte cmd_unlock=12;   // request to server to unlock object

    static final byte cmd_transaction=13;// send transaction to coordinator
    static final byte cmd_subtransact=14;// send local part of global trans.
    static final byte cmd_transresult=15;// coordinator returns trans. status
    static final byte cmd_tmsync=16;   // byteerserver transaction sync. message

    static final byte cmd_login=17;    // client login at server 
    static final byte cmd_logout=18;   // client finish the session
    static final byte cmd_connect=19;  // one server connects to other 
    static final byte cmd_bye=20;      // server notifies client  
                                       // about it's termination
    static final byte cmd_ok=21;       // successful authorization 
    static final byte cmd_refused=22;  // authorization procedure is failed at 
                                       // server
    static final byte cmd_alloc=23;    // request server to allocate object
    static final byte cmd_location=24; // server returns address of allocated 
                                       // object
    static final byte cmd_free=25;     // client request to free object
	

    //
    // Request fields offsets
    //
    static final int req_cmd_offs = 0;
    static final int req_arg1_offs = 1;
    static final int req_arg2_offs = 2;
    static final int req_arg3_offs = 4;
    static final int req_arg4_offs = 8;
    static final int req_arg5_offs = 12;

    static final int req_type_offs       = 1;
    static final int req_n_servers_offs  = 1;
    static final int req_align_offs      = 1;
    static final int req_status_offs     = 1;
    static final int req_coordinator_offs= 2;
    static final int req_flags_offs      = 2;
    static final int req_cpid_offs       = 2;
    static final int req_sid_offs        = 2;
    static final int req_attr_offs       = 2;
    static final int req_size_offs       = 4;
    static final int req_opid_offs       = 4;
    static final int req_extra_offs      = 8;
    static final int req_tid_offs        = 8;

    static final int req_size            = 16;

    static final int unpack2(byte[] data, int offs) { 
	return (data[offs] << 8) + (data[offs+1] & 0xFF); 
    }
    static final int unpack4(byte[] data, int offs) { 
	return (data[offs] << 24) + ((data[offs+1] & 0xFF) << 16) 
	    +  ((data[offs+2] & 0xFF) << 8) + (data[offs+3] & 0xFF); 
    }
    static final long unpack8(byte[] data, int offs) { 
	return ((long)unpack4(data, offs) << 32) 
	    + ((long)unpack4(data, offs+4) & 0xFFFFFFFFL);
    }
    static final String unpackAscii(byte[] data, int offs) { 
	int eos = offs;
	while (data[eos] != 0) { 
	    eos += 1;
	}
	return new String(data, 0, offs, eos - offs);
    }

    static final int pack2(byte[] data, int offs, int val) { 
	data[offs++] = (byte)(val >> 8);
	data[offs++] = (byte)val;
	return offs;
    }
    static final int pack4(byte[] data, int offs, int val) { 
	data[offs++] = (byte)(val >> 24);
	data[offs++] = (byte)(val >> 16);
	data[offs++] = (byte)(val >> 8);
	data[offs++] = (byte)val;
	return offs;
    }
    static final int pack8(byte[] data, int offs, long val) { 
        return pack4(data, pack4(data, offs, (int)(val >> 32)), (int)val);
    }

    static final int packAscii(byte[] data, int offs, String s) {
	int length = s.length();
	s.getBytes(0, length, data, offs);
	data[offs+length] = 0;
	return offs + length + 1;
    }
}







