//-< PessimisticRepeatableReadMetaobject.java >----------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// Java Program Interface                                            *  /  \  *
//                          Created:      1-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update:  9-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Metaobject for pessimistic scheme of synchronization with repeatable read
// isolation level
//-------------------------------------------------------------------*--------*

package goodsjpi;

public class PessimisticRepeatableReadMetaobject extends PessimisticMetaobject
{ 
    public void beginReadAccess(Persistent obj) {
	if ((obj.state & (Persistent.SLOCKED|Persistent.XLOCKED)) == 0) { 
	    obj.storage.lock(obj, Protocol.lck_shared, Protocol.lckattr_wait);
	    obj.state |= Persistent.SLOCKED;
	} 
    }

    public void endAccess(Persistent obj) { 
	int state = obj.state;
	if ((state & Persistent.TRANSWRITE) == 0 &&
	    (state & (Persistent.DIRTY|Persistent.XLOCKED)) != 0)
	{
	    addToTransaction(obj);
	} 
	else if ((state & (Persistent.TRANSREAD|Persistent.TRANSWRITE|
			   Persistent.SLOCKED)) == Persistent.SLOCKED)
	{
	    Assert.that((state & Persistent.DIRTY) == 0);
	    addToTransaction(obj);
	}	    
    }
}


