//-< PessimisticMetaobject.java >------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// Java Program Interface                                            *  /  \  *
//                          Created:      1-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update:  9-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Metaobject for pessimistic scheme of synchronization
//-------------------------------------------------------------------*--------*

package goodsjpi;

public class PessimisticMetaobject extends BasicMetaobject { 

    public void beginWriteAccess(Persistent obj) {
	if ((obj.state & Persistent.XLOCKED) == 0) { 
	    obj.storage.lock(obj, Protocol.lck_exclusive, 
			     Protocol.lckattr_wait);
	    obj.state |= Persistent.XLOCKED;
	} 
    }

    public void beginReadAccess(Persistent obj) {}

    public void endAccess(Persistent obj) { 
	int state = obj.state;
	if ((state & Persistent.TRANSWRITE) == 0 &&
	    (state & (Persistent.DIRTY|Persistent.XLOCKED)) != 0)
	{
	    addToTransaction(obj);
	} 
    }
}

