//-< Persistent.java >-----------------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// Java Program Interface                                            *  /  \  *
//                          Created:      1-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 16-Nov-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Base class for all persistent objects
//-------------------------------------------------------------------*--------*

package goodsjpi;

public class Persistent { 
    public Metaobject metaobject;

    ClassDescriptor desc; 

    boolean         invalidated; 
    byte[]          data; // packed object data (as in the storage) 

    int             opid;
    Storage         storage;
    
    Persistent      next; 
    Persistent      prev;

    int             accessCount;
    int             state;

    final static int DIRTY      = 0x0001;
    final static int RAW        = 0x0002;
    final static int CACHED     = 0x0004;
    final static int DESTRUCTED = 0x0008;
    final static int TRANSREAD  = 0x0010;
    final static int TRANSWRITE = 0x0020;
    final static int USEFUL     = 0x0040;
    final static int ACCESSED   = 0x0080;
    final static int SLOCKED    = 0x0100;
    final static int XLOCKED    = 0x0200;
    final static int NEW        = 0x0400;
    final static int OPTIMISTIC = 0x0800;
    final static int NOTIFY     = 0x1000;

    final protected void finalize() { 
	if (opid != 0) { 
	    storage.forgetObject(this);
	}
    }

    public synchronized void attachToStorage(Database db, int sid) { 
	Assert.that("persistent object can't change its location", opid == 0);
	storage = db.storages[sid];
    }

    public synchronized void clusterWith(Persistent obj) { 
	Assert.that("persistent object can't change its location", opid == 0);
	storage = obj.storage;
    }

    public Database getDatabase() { 
	return storage != null ? storage.database : null; 
    }

    public int getStorageId() { 
	return storage != null ? storage.id : -1; 
    }

    public int hashCode() { 
	Assert.that(opid != 0);
	return opid;
    }

    protected Persistent() {
	desc = ClassDescriptor.lookup(getClass());
	metaobject = desc.defaultMetaobject;
	metaobject.preDaemon(this, Metaobject.MUTATOR|Metaobject.CONSTRUCTOR);
    }

    protected Persistent(Metaobject metaobject) {
	this.metaobject = metaobject;
    }

    public final static Metaobject defaultMetaobject = 
        new PessimisticRepeatableReadMetaobject();
}    
