//-< OptimisticMetaobject.java >-------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// Java Program Interface                                            *  /  \  *
//                          Created:      1-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update:  9-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Metaobject for optimistic scheme of synchronization
//-------------------------------------------------------------------*--------*

package goodsjpi;

public class OptimisticMetaobject extends BasicMetaobject { 

    public void beginWriteAccess(Persistent obj) {}


    public void endAccess(Persistent obj) {
	if ((obj.state & (Persistent.TRANSWRITE|Persistent.DIRTY)) == 
	    Persistent.DIRTY) 
	{ 
	    addToTransaction(obj);
	    obj.state |= Persistent.OPTIMISTIC;
	}
    }

    public void beginReadAccess(Persistent obj) {}
}
