//-< Metaobject.java >-----------------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// Java Program Interface                                            *  /  \  *
//                          Created:      1-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update:  3-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Abstraction of metaobject protocol used by JAVAMOP preprocessor
//-------------------------------------------------------------------*--------*

package goodsjpi;


public abstract class Metaobject { 
    //
    // Invocation of this method is inserted by MOP generator before each
    // method invocation or object component access.
    //
    abstract public void preDaemon(Object obj, int attr);
    //
    // Invocation of this method is inserted by MOP generator after each
    // method invocation or object component access.
    //
    abstract public void postDaemon(Object obj, int attr, boolean modified);


    //
    // Attributes for daemons 
    //
    final public static int MUTATOR    = 1; // object can be changed
    final public static int VARIABLE   = 2; // access to non-self instance variable 
    final public static int CONSTRUCTOR= 4; // wrapped method is constructor
    final public static int EXCEPTION  = 8; // method is terminated by exception 

    //
    // This method is only hint to MOP preprocessor to consider method
    // invoking Metaobject.mutator() as been mutator. No actual code
    // will appear in preprocessed class file.
    //
    public static void mutator() {} 

    // 
    // This method provide MOP preprocessor with information that objects
    // was (or will be ) modified. No method invocation will appear in 
    // preprocessed code.
    //
    public static void modify() {} 

    //
    // GOODS specific metaobject methods
    //
    abstract protected void releaseObject(Persistent obj);

    abstract protected void commitObjectChanges(Persistent obj);

    abstract protected void undoObjectChanges(Persistent obj);

    abstract protected void makePersistent(Persistent obj, Persistent parent);

    abstract protected void beginReadAccess(Persistent obj);

    abstract protected void beginWriteAccess(Persistent obj);
    
    abstract protected void endAccess(Persistent obj);

    abstract protected void invalidateObject(Persistent obj);    

    abstract protected void destroyObject(Persistent obj);

    abstract protected void notifyOnModification(Persistent obj, boolean status);
}

    
