//-< CondEvent.java >------------------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// Java Program Interface                                            *  /  \  *
//                          Created:      1-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update:  9-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Event with automatic reset
//-------------------------------------------------------------------*--------*

package goodsjpi;

/**
 * This is a notification primitive used in GOODS Java API. By means of this
 * object client's threads can wait notifications about persistence
 * object instance modification event or transaction abort event. 
 * After signaling, event leaves in signaled state until some thread
 * invokes waitSignal() method. If waitSignal() method is invoked by thread 
 * before event was signaled, then thread is blocked until some other thread
 * will call signal() method. If several threads are waiting for event, only
 * one of them will awakeby signal() method.
 * 
 * Attention: waitSignal() method in general should not be called from 
 * synchronized method because caller object mutex will not be unlocked. 
 */
public class CondEvent { 
    private boolean signaled;

    public synchronized void signal() { 
	signaled = true;
	notify();
    }
    
    public synchronized void waitSignal() { 
        try { 
	    while (!signaled) { 
	        wait();
	    }
	} catch (InterruptedException x) {}
	signaled = false;
    }
}
	    
