//-< Assert.java >---------------------------------------------------*--------*
// GOODS                      Version 2.02       (c) 1998  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// Java Program Interface                                            *  /  \  *
//                          Created:     20-Jun-98    K.A. Knizhnik  * / [] \ *
//                          Last update:  8-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Runtime checking of current program state
//-------------------------------------------------------------------*--------*

package goodsjpi;

/** Class for checking program invariants. Analog of C <code>assert()</code>
 *  macro. As far as Java compiler doesn't provide information about compiled 
 *  file and line number, place of assertion failure can be located only 
 *  by analyzing stack trace of thrown AssertionFailed exception.
 *
 * @see     goodsjpi.AssertionFailed
 */
public class Assert { 
    /** Check specified condition and raise <code>AssertionFailed</code>
     *  exception if it is not true.
     * 
     * @param cond result of checked condition 
     */
    public static final void that(boolean cond) { 
        if (!cond) { 
	    throw new AssertionFailed();
	}
    }

    /** Check specified condition and raise <code>AssertionFailed</code>
     *  exception if it is not true. 
     * 
     * @param description string describing checked condition
     * @param cond result of checked condition 
     */
    public static final void that(String description, boolean cond) { 
        if (!cond) { 
	    throw new AssertionFailed(description);
	}
    }
}


