//-< TestBtree.java >------------------------------------------------*--------*
// GOODS                     Version 1.0         (c) 1997  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// Java Program Interface                                            *  /  \  *
//                          Created:     16-Jun-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 16-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Test program for Btree implementation
//-------------------------------------------------------------------*--------*

import goodsjpi.*;
import goodslib.*;
import java.util.Random;

class Record extends SetMember { 
    ArrayOfChar name;
    
    public int compare(Ordered rec) { 
	return name.compare(((Record)rec).name);
    }

    public int compareKey(Object key) { 
	return name.compare((String)key);
    }

    Record(String key) { 
	name = new ArrayOfChar(key);
    }

    static final Metaobject defaultMetaobject = new OptimisticMetaobject(); 
}


class Wood { 
    Btree[] tree;
    
    Wood(Database db, int nTrees, int pageSize) { 
	tree = new Btree[nTrees];
	for (int i = 0; i < nTrees; i++) {
	    tree[i] = new Btree(pageSize);
	    tree[i].attachToStorage(db, i % db.getNumberOfStorages());
	}
    }
}


public class TestBtree extends Thread { 
    final static int nTrees   = 2;
    final static int nRecords = 100;
    final static int nReads   = 10;
    final static int pageSize = 8;
    Database db;
    int      id;

    TestBtree(Database db, int id) { 
	this.db = db;
	this.id = id; 
	start();
    }

    public void run() { 
	int i, j;
	String key[] = new String[nRecords];
	Random rnd = new Random(1998+id);
	Btree tree = ((Wood)db.getRoot()).tree[id % nTrees];
	for (i = 0; i < nRecords; i++) { 
	    key[i] = "$" + rnd.nextLong() + "." + id;
	    tree.insert(new Record(key[i]));
	}
	for (i = 0; i < nReads; i++) { 
	    for (j = 0; j < nRecords; j++) { 
		Assert.that(tree.find(key[j]) != null);
	    }
	}
	for (i = 0; i < nRecords; i++) { 
	    tree.remove(tree.find(key[i]));
	}
	System.out.println("Process " + id + " terminated, " + 
			   tree.getNumberOfMembers() + " records in tree");
    }

    public static void main(String[] args) throws Exception { 
	int id = 0;
	int nThreads = 1;

	if (args.length > 0) { 
	    id = Integer.parseInt(args[0]);
	}
	if (args.length > 1) { 
	    nThreads = Integer.parseInt(args[1]);
	}
	Database db = new Database();

	if (db.open("btree.cfg")) { 
	    if (db.getRoot() == null) { 
		db.setRoot(new Wood(db, nTrees, pageSize));
	    }
	    Thread thread[] = new Thread[nThreads];
	    for (int i = 0; i < nThreads; i++) { 
		thread[i] = new TestBtree(db, id++);
	    }
	    while (--nThreads >= 0) { 
		thread[nThreads].join();
	    }
	    db.close();
	} else { 
	    System.err.println("Failed to open database");
	}
    }
}
		

