//-< TestBlob.java >-------------------------------------------------*--------*
// GOODS                     Version 1.0         (c) 1997  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
// Java Program Interface                                            *  /  \  *
//                          Created:     30-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 30-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Test program for Binary large object implementation
//-------------------------------------------------------------------*--------*

import goodsjpi.*;
import goodslib.*;

class TestBlob extends Blob { 
    static final int blobSize = 100000000;
    static final int segmentSize = 10000;
    static final int delay = 10;

    static int count;
    
    public boolean handle() {
	for (int i = 0; i < data.length; i++) { 
	    Assert.that(data[i] == (byte)count++); 
	}
	try { 
	    Thread.sleep(delay); 
	} catch (Exception x) {}
	return true; // default implementation does nothing
    }
    
    public static void main(String[] args) { 
	Database db = new Database();
	if (db.open("blob.cfg")) { 
	    TestBlob root = (TestBlob)db.getRoot();
	    if (root == null) { // initialize database
		System.out.println("Initializing database...");
		root = new TestBlob(segmentSize);
		db.setRoot(root);
		int size = 0; 
		while ((size += segmentSize) < blobSize) { 
		    root.append(new TestBlob(segmentSize));
		}
	    }
	    long start = System.currentTimeMillis();
	    count = 0;
	    root.play();
	    System.out.println("Blob.play time " 
			       + (System.currentTimeMillis() - start) 
			       + " miliseconds");
	    Assert.that(count == blobSize);
	    
	    start = System.currentTimeMillis();
	    count = 0;
	    for (TestBlob b = root; b != null; b = (TestBlob)b.next) { 
		b.handle();
	    }		
	    System.out.println("Sequential scan time " 
			       + (System.currentTimeMillis() - start) 
			       + " miliseconds");
	    Assert.that(count == blobSize);
	    
	    System.out.println("Total delay time " + blobSize/segmentSize*delay);
	    db.close();
	} else { 
	    System.err.println("Failed to open database");
	}
    }

    TestBlob(int size) {
	super(size); 
	for (int i = 0; i < size; i++) { 
	    data[i] = (byte)count++;
	}
    }

    static final Metaobject defaultMetaobject = new PessimisticMetaobject();
}




