//-< JSQL.java >-----------------------------------------------------*--------*
// GOODS                     Version 2.04        (c) 1997  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
//                                                                   *  /  \  *
//                          Created:      5-Mar-99    K.A. Knizhnik  * / [] \ *
//                          Last update:  5-Mar-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Test for Java embedded SQL
//-------------------------------------------------------------------*--------*

import goodsjpi.*;
import goodslib.*;
import java.io.*;
import java.util.Date;


class Record extends Persistent { 
    Record next;
    Record prev;

    static final Metaobject defaultMetaobject = new OptimisticMetaobject();

    Record() { 
	next = prev = this;
    }
    void unlink() { 
	next.prev = prev;
	prev.next = next;
    }
    void link(Record after) { 
	next = after.next;
	prev = after;
	after.next = next.prev = this;
    }
}

class ArrayOfContract extends ArrayOfObject { 
    public Contract get(int index) { 
	return (Contract)super.getAt(index);
    }    
    public ArrayOfContract(int size) {
	super(size);
    }
}


class Contractor extends Record { 
    ArrayOfContract contracts;

    void newContract(Contract contract) {
	contracts.push(contract);
    }
    void cancelContract(Contract contract) {
	contracts.remove(contracts.indexOf(contract), 1);
    }
    Contractor() { 
	contracts = new ArrayOfContract(0);
    }
}

class Detail extends Contractor { 
    String   name;
    String   material;
    String   color;
    double   weight;
}

class Supplier extends Contractor { 
    String   company;
    String   location;
    boolean  foreign;
}


class Contract extends Record   { 
    long     delivery;
    int      quantity;
    long     price;
    Detail   detail;
    Supplier supplier;
}

class Table extends Record implements QueryIterator { 
    String    primaryKey;
    HashTable hash;

    public Object getFirst() { 
	return next == this ? null : next;
    }
    public Object getNext(Object prevObj, int prevIndex) {
	Record next = ((Record)prevObj).next;
	return (next == this) ? null : next;
    }
    public Object getByKey(String key, Object keyValue) { 
	if (key.equals(primaryKey)) { 
	    return hash.get(keyValue);
	}
	throw new NoIndexException();
    }
    public void add(Record record, String keyValue) {
	if (hash != null) { 
	    hash.put(keyValue, record);
	}
	record.link(this);
    }
    public void remove(Record record, String keyValue) {
	if (hash != null) { 
	    hash.remove(keyValue);
	}
	record.unlink();
    }
    Table(String key) { 
	primaryKey = key;
	hash = key != null ? new HashTable() : null;
    }
}


class Metatable extends Persistent { 
    static final Metaobject defaultMetaobject = new OptimisticMetaobject();

    Table contracts;
    Table details;
    Table suppliers;
    
    Metatable() { 
	contracts = new Table(null);
	details   = new Table("name");
	suppliers = new Table("company");
    }
}



public class JSQL { 
    static byte[] inputBuffer = new byte[256];

    static String input(String prompt) {
	while (true) { 
	    try { 
		System.out.print(prompt);
		int len = System.in.read(inputBuffer);
		String answer = new String(inputBuffer, 0, len).trim();
		if (answer.length() != 0) {
		    return answer;
		}
	    } catch (IOException x) {}
	}
    }

    static public void main(String[] args) {
	int i, j;
	String name;
	String company;
	String material;
	String address;
	String condition;
	String price;
	String quantity;
	Date   from, till;
	Detail detail;
	Contract contract;
	Supplier supplier;

	String fileName = "test.dbs";
	Metatable all = null;
	Query q = new Query();
	Detail[] details;
	Contract[] contracts;
	Supplier[] suppliers;

	Database db = new Database();
	if (!db.open("jsql.cfg")) { 
	    System.out.println("Failed to open database");
	    return;
	}
	all = (Metatable)db.getRoot();
	if (all == null) { 
	    all = new Metatable();
	    db.setRoot(all);
	}
	while (true) { 	    
	    System.out.println("\n\n    MENU:");
	    System.out.println("1.  Details shipped by supplier");
	    System.out.println("2.  Suppliers of the detail");
	    System.out.println("3.  Contracts from specified city");
	    System.out.println("4.  Expensive details to be delivered in specified period");
	    System.out.println("5.  Foreign suppliers");
	    System.out.println("6.  Important contracts");
	    System.out.println("7.  Search for detail");
	    System.out.println("8.  Search for supplier");
	    System.out.println("9.  Search for contract");
	    System.out.println("10. New supplier");
	    System.out.println("11. New detail");
	    System.out.println("12. New contract");
	    System.out.println("13. Cancel contract");
	    System.out.println("14. Exit\n\n");

	    i = 0;
	    try { 
		i = Integer.parseInt(input(">> "), 10);
	    } catch(NumberFormatException x) {}
	    switch (i) { 
	      case 1:
		System.out.println("Details shipped by supplier");
		company = input("Supplier company: ");
		details = (Detail[])q.select("Detail", all.details, 
		    "exists i:(contracts[i].supplier.company='"+company+"')");
		
		System.out.println("Detail\tMaterial\tColor\tWeight");
		for (i = 0; i < details.length; i++) { 
		    System.out.println(details[i].name + "\t" +
				       details[i].material + "\t" +
				       details[i].color + "\t" +
				       details[i].weight);
		} 
		break;
	      case 2:
		System.out.println("Suppliers of the detail");
		name = input("Regular expression for detail name: ");
		details = (Detail[])q.select("Detail", all.details, 
					     "name like '"+name+"'");
		System.out.println("Detail\tCompany\tLocation\tPrice");
		for (i = 0; i < details.length; i++) { 
		    for (j = 0; j < details[i].contracts.length(); j++) { 
			supplier = details[i].contracts.get(j).supplier;
			System.out.println(details[i].name + "\t" +  
					   supplier.company + "\t" + 
					   supplier.location + "\t$" + 
					   details[i].contracts.get(j).price);
		    }
		}
		break;
	      case 3:
		System.out.println("Contracts from specified city");
		address = input("City: ");
		contracts = (Contract[])q.select("Contract", all.contracts, 
			    "supplier.location ='"+address+"'");
		System.out.println("Detail\tCompany\tQuantity");
		for (i = 0; i < contracts.length; i++) { 
		    System.out.println(contracts[i].detail.name + "\t" + 
				       contracts[i].supplier.company + "\t" + 
				       contracts[i].quantity);
		}
		break;
	      case 4:
		System.out.println("Expensive details to be delivered in specified period");
		from = new Date(input("Delivered after (Day Month Year): "));
		till = new Date(input("Delivered before (Day Month Year): "));
		
		price = input("Minimal contract price: ");
		contracts = (Contract[])q.select("Contract", all.contracts, 
						 "delivery between "
						 +from.getTime() + " and "
						 +till.getTime()+"and price > "
						 +price + "order by price");
		System.out.println("Detail\tDate\tPrice");
		for (i = 0; i < contracts.length; i++) { 
		    System.out.println(contracts[i].detail.name + "\t" + 
				       new Date(contracts[i].delivery) + "\t" +
				       contracts[i].price);
		}
		break;
	      case 5:
		System.out.println("Foreign suppliers");
		suppliers = (Supplier[])q.select("Supplier", all.suppliers, 
			    "foreign and length(contracts)>0");
		System.out.println("Company\tLocation");
		for (i = 0; i < suppliers.length; i++) { 
		    System.out.println(suppliers[i].company + "\t" + 
				       suppliers[i].location);
		}
		break;
	      case 6:
		System.out.println("Important contracts");
		price = input("Minimal contract price: ");
		quantity = input("Minimal contract quantity: ");
		contracts = (Contract[])q.select("Contract", all.contracts, 
			    "(price >=" + price + " or quantity >=" + quantity
			    +")");
		System.out.println("Company\tPrice\tQuantity\tDelivery");
		for (i = 0; i < contracts.length; i++) { 
		    System.out.println(contracts[i].supplier.company + "\t$" + 
				       contracts[i].price + "\t" + 
				       contracts[i].quantity + "\t" + 
				       new Date(contracts[i].delivery));
		}
		break;
	      case 7:
		System.out.println("Select details");
		condition = input("Condition: ");
		try { 
		    details = 
			(Detail[])q.select("Detail", all.details, condition);
		} catch(CompileError x) { 
		    System.out.println(x);
		    break;
		}
		System.out.println("Detail\tMaterial\tColor\tWeight");
		for (i = 0; i < details.length; i++) { 
		    System.out.println(details[i].name + "\t" +
				       details[i].material + "\t" +
				       details[i].color + "\t" +
				       details[i].weight);
		} 
		break;
	      case 8:
		System.out.println("Select suppliers");
		condition = input("Condition: ");
		try { 
		    suppliers = (Supplier[])q.select("Supplier", all.suppliers,
						     condition);
		} catch(CompileError x) { 
		    System.out.println(x);
		    break;
		}
		System.out.println("Company\tLocation");
		for (i = 0; i < suppliers.length; i++) { 
		    System.out.println(suppliers[i].company + "\t" + 
				       suppliers[i].location);
		}
		break;
	      case 9:
		System.out.println("Select contracts");
		condition = input("Condition: ");
		try { 
		    contracts = (Contract[])q.select("Contract", all.contracts,
						     condition);
		} catch(CompileError x) { 
		    System.out.println(x);
		    break;
		}
		System.out.println("Company\tDetail\tPrice\tQuantity");
		for (i = 0; i < contracts.length; i++) { 
		    System.out.println(contracts[i].supplier.company + "\t" + 
				       contracts[i].detail.name + "\t$" + 
				       contracts[i].price + "\t" + 
				       contracts[i].quantity); 
		}
		break;
	      case 10:
		System.out.println("New supplier");
		supplier = new Supplier();
		supplier.company = input("Company name: ");
		supplier.location = input("Company location: ");
		supplier.foreign =input("Foreign company (y/n): ").equals("y");
		all.suppliers.add(supplier, supplier.company);
		break;
	      case 11:
		System.out.println("New detail");
		detail = new Detail();
		detail.name = input("Detail name: ");
		detail.material = input("Detail material: ");
		try {
		    detail.weight = 
			Double.valueOf(input("Detail weight: ")).doubleValue();
		} catch(NumberFormatException x) { 
		    System.out.println("Bad number format");
		    break;
		}
		detail.color = input("Detail color: ");
		all.details.add(detail, detail.name);
		break;
	      case 12:
		System.out.println("New contract");
		company = input("Supplier company: ");
		suppliers = (Supplier[])q.select("Supplier", all.suppliers, 
						 "company='"+company+"'");
		if (suppliers.length == 0) { 
		    System.out.println("No such supplier");
		    break;
		}
		if (suppliers.length != 1) { 
		    System.out.println("More than one suppliers with this name");
		    break;
		}
		name = input("Detail name: ");
		details = (Detail[])q.select("Detail", all.details,
					     "name like '"+name+"'");
		if (details.length == 0) { 
		    System.out.println("No such detail");
		    break;
		} else if (details.length != 1) { 
		    System.out.println("More than one record match this pattern");
		    break; 
		}
		contract = new Contract();
		contract.supplier = supplier = suppliers[0];
		contract.detail = detail = details[0];
		try { 
		    contract.price =
			Long.parseLong(input("Contract price: "), 10);
		    contract.quantity = 
			Integer.parseInt(input("Contract quantity:  "), 10);
		} catch(NumberFormatException x) { 
		    System.out.println("Bad number format");
		    break;
		}
		contract.delivery = new Date
		    (input("Delivery date (Day Month Year): ")).getTime();
		
		detail.newContract(contract);
		supplier.newContract(contract);
		all.contracts.add(contract, null);
		break;
	      case 13: 
		System.out.println("Cancel contract");
		company = input("Supplier company: ");
		name = input("Detail name pattern: ");
		contracts = (Contract[])q.select("Contract", all.contracts,
			    "supplier.company='"+company
			    +"'and detail.name like'"+name+"'");
		if (contracts.length == 0) {
		    System.out.println("No such contracts");
		    break;
		}
		for (i = 0; i < contracts.length; i++) { 
		    contracts[i].unlink();
		    contracts[i].supplier.cancelContract(contracts[i]);
		    contracts[i].detail.cancelContract(contracts[i]);
		}
		break;
	      case 14:
		if (input("Do you really want to exit (y/n) ? ").equals("y")) {
		    db.close();
		    return;
		}
		break;
	      default:
		System.out.println("Please choose menu items 1..14\n");
	    }
	    System.out.println("Press Return to continue...");
	    try { 
		System.in.read(inputBuffer);
	    } catch (IOException x) {}
	}
    }
}









