//-< Guess2.java >---------------------------------------------------*--------*
// GOODS                     Version 1.0         (c) 1997  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
//                                                                   *  /  \  *
//                          Created:     13-Jan-99    K.A. Knizhnik  * / [] \ *
//                          Last update: 13-Jan-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Example program: game "Guess an animal". 
// This implementation uses String 
//-------------------------------------------------------------------*--------*

import goodsjpi.*;
import java.io.*;

public class Guess2 extends Persistent {
    public Guess2 yes;
    public Guess2 no;
    public String question; // byte[] type is used for compatibility with C++

    static final Metaobject defaultMetaobject = new OptimisticMetaobject();

    static byte[] inputBuffer = new byte[256];


    public Guess2(Guess2 no, String question, Guess2 yes) { 
	this.yes = yes;
	this.question = question;
	this.no = no;
    }

    static String input(String prompt) {
	while (true) { 
	    try { 
		System.out.print(prompt);
		int len = System.in.read(inputBuffer);
		String answer = new String(inputBuffer, 0, len).trim();
		if (answer.length() != 0) {
		    return answer;
		}
	    } catch (IOException x) {}
	}
    }

    static boolean askQuestion(String question) { 
	String answer = input(question);
	return answer.equalsIgnoreCase("y") || answer.equalsIgnoreCase("yes");
    }

    static Guess2 whoIsIt(Guess2 parent) { 
	String animal = input("What is it ? ");
	String difference = input("What is a difference from other ? ");
	return new Guess2(parent, difference, new Guess2(null, animal, null));
    }

    Guess2 dialog() {  
	if (askQuestion("May be, " + question + " (y/n) ? ")) {
	    if (yes == null) { 
		System.out.println("It was very simple question for me...");
	    } else { 
		Guess2 clarify = yes.dialog();
		if (clarify != null) { 
		    yes = clarify;
		}
	    }
	} else { 
	    if (no == null) { 
		if (yes == null) { 
		    return whoIsIt(this);
		} else {
		    no = whoIsIt(null);
		} 
	    } else { 
	        Guess2 clarify = no.dialog();
		if (clarify != null) { 
		    no = clarify;
		}
	    }
	}
	return null; 
    }
    
    static public void main(String[] args) {
	Database db = new Database();
	String cfgName = "guess.cfg";

	if (db.open(cfgName)) { 
	    TransactionArbiter arbiter = new TransactionArbiter(db);
	    Guess2 root = (Guess2)db.getRoot();

	    while (askQuestion("Think of an animal. Ready (y/n) ? ")) { 
		if (root == null) { 
		    root = whoIsIt(null);
		    db.setRoot(root);
		} else { 
		    root.dialog();
		}
	    }
	    
	    System.out.println("End of the game");
	    db.close();
	    arbiter.terminate();
	} else { 
	    System.out.println("Failed to open database");
	}
    }
}


//
// Handle write conflict during optimistic transaction commit
//
class TransactionArbiter extends Thread { 
    volatile boolean running;
    CondEvent        event;

    TransactionArbiter(Database db) { 
	running = true;
	event = new CondEvent();
	db.notifyOnTransactionAbort(event);
	start();
    }

    public void run() { 
	while (true) { 
	    event.waitSignal();
	    if (running) { 
		System.out.println("Let's try again...");
	    } else { 
		return;
	    }
	}
    }
    public void terminate() { 
	running = false;
	event.signal();
	try { 
	    join();
	} catch(InterruptedException x) {}
    }
}



