//-< Guess.java >----------------------------------------------------*--------*
// GOODS                     Version 1.0         (c) 1997  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
//                                                                   *  /  \  *
//                          Created:     10-Oct-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 10-Oct-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Example program: game "Guess an animal"
//-------------------------------------------------------------------*--------*

import goodsjpi.*;
import java.io.*;

public class Guess extends Persistent {
    public Guess  yes;
    public Guess  no;
    public byte[] question; // byte[] type is used for compatibility with C++

    static final Metaobject defaultMetaobject = new OptimisticMetaobject();

    static byte[] inputBuffer = new byte[256];


    public Guess(Guess no, String question, Guess yes) { 
	this.yes = yes;
	this.question = Conversion.StringToAsciiz(question);
	this.no = no;
    }

    static String input(String prompt) {
	while (true) { 
	    try { 
		System.out.print(prompt);
		int len = System.in.read(inputBuffer);
		String answer = new String(inputBuffer, 0, len).trim();
		if (answer.length() != 0) {
		    return answer;
		}
	    } catch (IOException x) {}
	}
    }

    static boolean askQuestion(String question) { 
	String answer = input(question);
	return answer.equalsIgnoreCase("y") || answer.equalsIgnoreCase("yes");
    }

    static Guess whoIsIt(Guess parent) { 
	String animal = input("What is it ? ");
	String difference = input("What is a difference from other ? ");
	return new Guess(parent, difference, new Guess(null, animal, null));
    }

    Guess dialog() {  
	if (askQuestion("May be, " + Conversion.AsciizToString(question) 
			+ " (y/n) ? ")) {
	    if (yes == null) { 
		System.out.println("It was very simple question for me...");
	    } else { 
		Guess clarify = yes.dialog();
		if (clarify != null) { 
		    yes = clarify;
		}
	    }
	} else { 
	    if (no == null) { 
		if (yes == null) { 
		    return whoIsIt(this);
		} else {
		    no = whoIsIt(null);
		} 
	    } else { 
	        Guess clarify = no.dialog();
		if (clarify != null) { 
		    no = clarify;
		}
	    }
	}
	return null; 
    }
    
    static public void main(String[] args) {
	Database db = new Database();
	String cfgName = "guess.cfg";

	if (db.open(cfgName)) { 
	    TransactionArbiter arbiter = new TransactionArbiter(db);
	    Guess root = (Guess)db.getRoot();

	    while (askQuestion("Think of an animal. Ready (y/n) ? ")) { 
		if (root == null) { 
		    root = whoIsIt(null);
		    db.setRoot(root);
		} else { 
		    root.dialog();
		}
	    }
	    
	    System.out.println("End of the game");
	    db.close();
	    arbiter.terminate();
	} else { 
	    System.out.println("Failed to open database");
	}
    }
}


//
// Handle write conflict during optimistic transaction commit
//
class TransactionArbiter extends Thread { 
    volatile boolean running;
    CondEvent        event;

    TransactionArbiter(Database db) { 
	running = true;
	event = new CondEvent();
	db.notifyOnTransactionAbort(event);
	start();
    }

    public void run() { 
	while (true) { 
	    event.waitSignal();
	    if (running) { 
		System.out.println("Let's try again...");
	    } else { 
		return;
	    }
	}
    }
    public void terminate() { 
	running = false;
	event.signal();
	try { 
	    join();
	} catch(InterruptedException x) {}
    }
}



