import java.awt.*;
import goodsjpi.*;
import goodslib.HashTable;

public class Catalog extends Persistent { 
    public Drawing   drawings;
    public HashTable hashtable;

    public List buildList() { 
	List list = new List();
	for (Drawing d = drawings; d != null; d = d.next) { 
	    list.addItem(d.name.asString());
	}
	return list;
    }

    public Drawing find(String name) { 
	return (Drawing)hashtable.get(name);
    }

    public void add(Drawing d) { 
	hashtable.put(d.name, d);
	d.next = drawings;
	drawings = d;
    }

    public Catalog(int hashTableSize) { 
	hashtable = new HashTable(hashTableSize);
    }
}
