#ifndef __CONVERT_H__
#define __CONVERT_H__

#if defined(__FreeBSD__)
#include <sys/param.h>
#define USE_HTON_NTOH
#elif defined(__linux__)
//
// At Linux inline assembly declarations of ntohl, htonl... are available
//
#include <netinet/in.h>
#define USE_HTON_NTOH
#else
#if defined(_WIN32) && _M_IX86 >= 400
#pragma warning(disable:4035) // disable "no return" warning
inline int swap_bytes_in_dword(int val) {
    __asm {
          mov eax, val
          bswap eax
    }
}
inline short swap_bytes_in_word(short val) {
    __asm {
          mov ax, val
          xchg al,ah
    }
}
#pragma warning(default:4035)
#define ntohl(w) swap_bytes_in_dword(w)
#define htonl(w) swap_bytes_in_dword(w)
#define ntohs(w) swap_bytes_in_word(w)
#define htons(w) swap_bytes_in_word(w)

#define USE_HTON_NTOH
#endif
#endif




inline char* pack2(char* dst, nat2 val) { 
    *dst++ = char(val >> 8);
    *dst++ = char(val);     
    return dst;
}

inline char* pack2(char* dst, char* src) { 
    return pack2(dst, *(nat2*)src); 
}

inline void pack2(nat2& val) { 
#if BYTE_ORDER != BIG_ENDIAN
#ifdef USE_HTON_NTOH
    val = htons(val);
#else
    pack2((char*)&val, val); 
#endif
#endif
}


inline char* pack4(char* dst, nat4 val) { 
    *dst++ = char(val >> 24);
    *dst++ = char(val >> 16);     
    *dst++ = char(val >> 8); 
    *dst++ = char(val);
    return dst;
}

inline char* pack4(char* dst, char* src) { 
    return pack4(dst, *(nat4*)src); 
}

inline void pack4(nat4& val) { 
#if BYTE_ORDER != BIG_ENDIAN
#ifdef USE_HTON_NTOH
    val = htonl(val);
#else
    pack4((char*)&val, val); 
#endif
#endif
}


inline char* pack8(char* dst, char* src) { 
#if BYTE_ORDER == BIG_ENDIAN
    return pack4( pack4(dst, src), src + 4);
#else
    return pack4( pack4(dst, src + 4), src);
#endif
}

inline char* packref(char* dst, nat2 sid, opid_t opid) { 
    return pack4( pack2(dst, sid), opid);
}




inline nat2 unpack2(char* src) { 
    nat1* s = (nat1*)src;
    return (s[0] << 8) + s[1]; 
}

inline char* unpack2(char* dst, char* src) { 
    *(nat2*)dst = unpack2(src);
    return src + 2;
}

inline void  unpack2(nat2& val) { 
#if BYTE_ORDER != BIG_ENDIAN
#ifdef USE_HTON_NTOH
    val = ntohs(val);
#else
    val = unpack2((char*)&val); 
#endif
#endif
}


inline nat4  unpack4(char* src) { 
    nat1* s = (nat1*)src;
    return (((((s[0] << 8) + s[1]) << 8) + s[2]) << 8) + s[3];
} 

inline char* unpack4(char* dst, char* src) { 
    *(nat4*)dst = unpack4(src);
    return src + 4;
}

inline void unpack4(nat4& val) { 
#if BYTE_ORDER != BIG_ENDIAN
#ifdef USE_HTON_NTOH
    val = ntohl(val);
#else
    val = unpack4((char*)&val); 
#endif
#endif
}

inline char* unpack8(char* dst, char* src) { 
#if BYTE_ORDER == BIG_ENDIAN
    *(nat4*)dst = unpack4(src);
    *((nat4*)dst+1) = unpack4(src+4);
#else
    *(nat4*)dst = unpack4(src+4);
    *((nat4*)dst+1) = unpack4(src);
#endif
    return src + 8;
}

inline char* unpackref(nat2& sid, opid_t& opid, char* src) { 
    return unpack4((char*)&opid, unpack2((char*)&sid, src));
}

#endif

