//-< CONSOLE.H >-----------------------------------------------------*--------*
// GOODS                     Version 1.0         (c) 1997  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
//                                                                   *  /  \  *
//                          Created:      7-Jan-97    K.A. Knizhnik  * / [] \ *
//                          Last update:  1-Mar-97    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Handle information and error messages at virtual console.
//-------------------------------------------------------------------*--------*

#ifndef __CONSOLE_H__
#define __CONSOLE_H__

#if DEBUG_LEVEL == DEBUG_TRACE
#define TRACE_MSG(x) console::message x
#else
#define TRACE_MSG(x)
#endif

enum console_message_classes { 
    msg_time      = 0x001, // include timestamp in message
    msg_error     = 0x002, // messages about some non-fatal errors
    msg_notify    = 0x004, // notification messages
    msg_login     = 0x008, // messages about clients login/logout 
    msg_warning   = 0x010, // messages about some possibly incorrect operations
    msg_important = 0x020, // trace messages about some important events
    msg_object    = 0x040, // trace operations with object instances
    msg_locking   = 0x080, // object lock related tracing
    msg_request   = 0x100, // trace requests received by server
    msg_gc        = 0x200, // trace garbage collector activity
    msg_output    = 0x400, // message which will be always shown
    msg_all       = ~0,    // output all messages
    msg_none      = 0      // ignore all messages
};

class console { 
  protected:
    FILE* log;

    enum output_type { 
	con_data,
	con_message, 
	con_error
    };

    virtual void output_data(output_type, const char* msg, va_list args);
    virtual boolean input_data(char* buf, size_t buf_size);
 
  public:
    static console* active_console; 
    static int      trace_mask;
    //
    // Output data at console.
    //

    static void output(const char* msg, ...); 
    //
    // Output message of class belonging to trace_mask at console
    //
    static void message(int message_class_mask, const char* msg, ...); 

    //
    // Output message at console and terminate program. 
    //
    static void error(const char* msg, ...);       

    //
    // Input information from console
    //
    static boolean input(char* buf, size_t buf_size);

    static void use_log_file(FILE* log, boolean auto_close = True); 

    console();
}; 

#endif



