//-< CONSOLE.CXX >---------------------------------------------------*--------*
// GOODS                     Version 1.0         (c) 1997  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
//                                                                   *  /  \  *
//                          Created:      7-Jan-97    K.A. Knizhnik  * / [] \ *
//                          Last update: 26-Apr-97    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Handle information and error messages at virtual console.
//-------------------------------------------------------------------*--------*

#include "stdinc.h"

console* console::active_console;
int console::trace_mask = msg_error|msg_notify|msg_login;
static console default_console; 

console::console ()
{
    log = NULL; 
    if (active_console == NULL || active_console == &default_console) { 
	active_console = this; 
    }
}

void console::output(const char* msg, ...) 
{
    va_list args;
    va_start (args, msg);
    assert(active_console != NULL);
    active_console->output_data(con_data, msg, args);
    va_end (args);
}

void console::message(int message_class_mask, const char* msg, ...) 
{
    if ((trace_mask | msg_output) & message_class_mask & ~msg_time) { 
	va_list args;
	va_start (args, msg);
	assert(active_console != NULL);

	if (message_class_mask & msg_time) { 
	    static char* months[] = {"JAN", "FEB", "MAR", "APR", "MAY", "JUN",
				     "JUL", "AUG", "SEP", "NOV", "OCT", "DEC"};
	    char format[256];
	    time_t aclock;
	    time(&aclock);
	    struct tm* tp = localtime(&aclock);
	    if (8 + 1 + 9 + 3 + strlen(msg) > sizeof format) { 
		output("%02u:%02u.%02u %02u-%s-%02u: ", 
		       tp->tm_hour, tp->tm_min, tp->tm_sec, 
		       tp->tm_mday, months[tp->tm_mon], tp->tm_year);
		active_console->output_data(con_message, msg, args);
	    } else { 
		sprintf(format, "%02u:%02u.%02u %02u-%s-%02u: %s", 
			tp->tm_hour, tp->tm_min, tp->tm_sec, 
			tp->tm_mday, months[tp->tm_mon], tp->tm_year, msg);
		active_console->output_data(con_message, format, args);
	    }
	} else { 
	    active_console->output_data(con_message, msg, args);
	}
	va_end (args);
    }
}

void console::error(const char* msg, ...) 
{
    va_list args;
    va_start (args, msg);
    assert(active_console != NULL);
    active_console->output_data(con_error, msg, args);
    va_end (args);
    abort();
}

boolean console::input(char* buf, size_t buf_size)
{
    return active_console->input_data(buf, buf_size);
}

void console::use_log_file(FILE* log, boolean auto_close)
{
    if (auto_close && active_console->log != NULL) { 
	fclose(active_console->log);
    }
    active_console->log = log;
}

void console::output_data(output_type, const char* msg, va_list args)
{
    vfprintf(stdout, msg, args);
    if (log != NULL) { 
	vfprintf(log, msg, args);
    }
}

#ifdef COOPERATIVE_MULTITASKING
#include <unistd.h>
#include "unisock.h"

boolean console::input_data(char* dst, size_t dst_size)
{
    static unix_socket stdin_socket(0);
    static char  buf[4096];
    static char* bp = buf;
    static int   used;

    if (dst_size == 0) { 
	return False;
    }
    int   src_size = used;
    char* src = bp;

    fflush(stdout);

    while (True) { 
	while (src_size > 0 && dst_size > 1) {
	    src_size -= 1;
	    dst_size -= 1;
	    if ((*dst++ = *src++) == '\n') { 
		*dst = '\0';
		bp = src; 
		used = src_size;
		return True;
	    }
	}
	if (dst_size == 1) { 
	    *dst++ = '\0';
	    bp = src;	
	    used = src_size;
	    return True;
	} else { 
	    stdin_socket.wait_input();
	    int rc = read(0, buf, sizeof buf);
	    if (rc > 0) { 
		src_size = rc; 
		src = buf;
	    } else { 
		used = 0;
		bp = buf;
		return False;
	    }
	}
    }
}

#else

boolean console::input_data(char* buf, size_t buf_size)
{
    return fgets(buf, buf_size, stdin) != NULL; 
} 

#endif
