//-< CLIENT.H >------------------------------------------------------*--------*
// GOODS                     Version 1.0         (c) 1997  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
//                                                                   *  /  \  *
//                          Created:      7-Jan-97    K.A. Knizhnik  * / [] \ *
//                          Last update: 23-May-97    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Client store interface. This store is responsible for tranferring          
// client requests to server and receiving server's replies.  
//-------------------------------------------------------------------*--------*

#ifndef __CLIENT_H__
#define __CLIENT_H__

#include "sockio.h"

class dbs_client_storage : public dbs_storage 
{ 
  protected:
    socket_t*       sock;

    semaphore       rcv_sem;  // enable request receiving
    semaphore       rep_sem;  // reply received
    mutex           snd_cs;   // sending in progress

    boolean         opened;
    boolean         closing;
    event           term_event; 

    dnm_buffer      snd_buf; 
    dbs_request     reply;
    
    boolean         waiting_reply;
    boolean         proceeding_invalidation;

    mutex           notify_cs;
    dnm_array<dbs_request> notify_buf;

    virtual void    read(void* buf, size_t size);
    virtual void    write(void const* buf, size_t size);
    virtual boolean handle_communication_error();

    static void task_proc receiver(void*); 
    virtual void    receive_header();

    virtual void    send_receive(void const*  snd_buf, 
				 size_t       snd_lene,
				 dbs_request& rcv_req, 
				 int          exp_cmd);

    virtual void    send_receive(void const*  snd_buf, 
				 size_t       snd_lene,
				 dbs_request& rcv_req, 
				 int          exp_cmd,
				 dnm_buffer&  rcv_buf);

    virtual void    send_notifications();

  public:
    virtual opid_t  allocate(cpid_t cpid, size_t size, boolean aligned);
    virtual void    deallocate(opid_t opid);

    virtual boolean lock(opid_t opid, lck_t lck, int attr);
    virtual void    unlock(opid_t opid, lck_t lck);
    
    virtual void    get_class(cpid_t cpid, dnm_buffer& buf);
    virtual cpid_t  put_class(dbs_class_descriptor* desc);
    virtual void    change_class(cpid_t cpid, dbs_class_descriptor* desc);
					    
    //
    // Load object from server into buffer. 
    //
    virtual void    load(opid_t* opid, int n_objects, int flags, 
			 dnm_buffer& buf);
    virtual void    load(opid_t opid, int flags, dnm_buffer& buf);

    //
    // Inform server about state of object cache
    //
    virtual void    forget_object(opid_t opid);
    virtual void    throw_object(opid_t opid); 

    //
    // Initiate transaction at server
    //
    virtual void    begin_transaction(dnm_buffer& buf); 

    virtual boolean commit_coordinator_transaction(int n_trans_servers, 
						   sid_t* trans_servers,
						   dnm_buffer& dnm, 
						   tid_t& tid);
    virtual void    commit_transaction(sid_t coordinator, 
				       int n_trans_servers,
				       sid_t* trans_servers,
				       dnm_buffer& dnm, 
				       tid_t tid);
    virtual boolean wait_global_transaction_completion();

    //
    // Establish connection with server, returns 'False' if connection failed
    //
    virtual boolean open(const char* server_connection_name);
    virtual void    close();

    dbs_client_storage(sid_t sid, dbs_application* app) 
    : dbs_storage(sid, app) {} 
    virtual~dbs_client_storage();
};

#endif

