//-< CGIAPI.CXX >----------------------------------------------------*--------*
// GOODS                     Version 1.0         (c) 1997  GARRET    *     ?  *
// (Generic Object Oriented Database System)                         *   /\|  *
//                                                                   *  /  \  *
//                          Created:     27-Mar-99    K.A. Knizhnik  * / [] \ *
//                          Last update:  4-Apr-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Implementation of CGIapi class
//-------------------------------------------------------------------*--------*

#include "cgiapi.h"
#include "support.h"
#include "convert.h"

const size_t init_request_buffer_size = 4*1024;
const size_t init_reply_buffer_size = 4*1024;

CGIrequest::CGIrequest()
{
    memset(hash_table, 0, sizeof hash_table);
    sock = NULL;
    request_buf = new char[init_request_buffer_size];
    request_buf_size = init_request_buffer_size;
    reply_buf = new char[init_reply_buffer_size];
    reply_buf_size = init_reply_buffer_size;
    free_pairs = NULL;
}

CGIrequest::~CGIrequest()
{
    reset();
    name_value_pair *nvp, *next;
    for (nvp = free_pairs; nvp != NULL; nvp = next) { 
	next = nvp->next;
	delete nvp;
    }
    delete[] reply_buf;
    delete[] request_buf;
}


inline char* CGIrequest::extendBuffer(size_t inc)
{
    if (reply_buf_used + inc > reply_buf_size) { 
	reply_buf_size = reply_buf_size*2 > reply_buf_used + inc
	    ? reply_buf_size*2 : reply_buf_used + inc;
	char* new_buf = new char[reply_buf_size];
	memcpy(new_buf, reply_buf, reply_buf_used);
	delete[] reply_buf;
	reply_buf = new_buf;
    }     
    reply_buf_used += inc;
    return reply_buf;
}

boolean CGIrequest::terminatedBy(char const* str) const
{
    size_t len = strlen(str);
    if (len > reply_buf_used - 4) { 
	return False;
    }
    return memcmp(reply_buf + reply_buf_used - len, str, len) == 0;
}

CGIrequest& CGIrequest::append(char const* str) 
{
    int pos = reply_buf_used;
    char* dst = extendBuffer(strlen(str));
    unsigned char ch;
    switch (encoding) {
      case TAG:
	strcpy(dst + pos, str);
	encoding = HTML;
	break;
      case HTML:
	encoding = TAG;
	while (True) { 
	    switch(ch = *str++) { 
	      case '<':
		dst = extendBuffer(3);
		dst[pos++] = '&';
		dst[pos++] = 'l';
		dst[pos++] = 't';
		dst[pos++] = ';';
		break;
	      case '>':
		dst = extendBuffer(3);
		dst[pos++] = '&';
		dst[pos++] = 'l';
		dst[pos++] = 't';
		dst[pos++] = ';';
		break;
	      case '"':
		dst = extendBuffer(4);
		dst[pos++] = '&';
		dst[pos++] = 'a';
		dst[pos++] = 'm';
		dst[pos++] = 'p';
		dst[pos++] = ';';
		break;
	      case '&':
		dst = extendBuffer(5);
		dst[pos++] = '&';
		dst[pos++] = 'q';
		dst[pos++] = 'u';
		dst[pos++] = 'o';
		dst[pos++] = 't';
		dst[pos++] = ';';
		break;
	      case '\0':
		dst[pos] = '\0';
		return *this;
	      default:
		dst[pos++] = ch;
	    }
	}
	break;
      case URL:
	encoding = TAG;
	while (True) { 
	    ch = *str++;
	    if (ch == '\0') { 
		dst[pos] = '\0';
		return *this;
	    } else if (ch == ' ') { 
		dst[pos++] = '+';
	    } else if (!isalnum(ch)) { 
		dst = extendBuffer(2);
		dst[pos++] = '%';
		dst[pos++] = (ch >> 4) >= 10 
		    ? (ch >> 4) + 'A' - 10 : (ch >> 4) + '0';
		dst[pos++] = (ch & 0xF) >= 10
		    ? (ch & 0xF) + 'A' - 10 : (ch & 0xF) + '0';
	    } else { 
		dst[pos++] = ch;
	    }
	}
    }
    return *this;
}


void CGIrequest::reset()
{
    if (sock != NULL) { 
	delete sock;
	sock = NULL;
    }
    reply_buf_used = 4;
    encoding = TAG;
    for (int i = items(hash_table); --i >= 0;) { 
	name_value_pair *nvp, *next;
	for (nvp = hash_table[i]; nvp != NULL; nvp = next) { 
	    next = nvp->next;
	    nvp->next = free_pairs;
	    free_pairs = nvp;
	}
	hash_table[i] = NULL;
    }	    
}

void CGIrequest::addPair(char const* name, char const* value)
{
    name_value_pair* nvp;
    if (free_pairs != NULL) { 
	nvp = free_pairs;
	free_pairs = nvp->next;
    } else { 
	nvp = new name_value_pair;
    }
    unsigned hash_code = string_hash_function(name);
    nvp->hash_code = hash_code;
    hash_code %= hash_table_size;
    nvp->next = hash_table[hash_code];
    hash_table[hash_code] = nvp;
    nvp->value = value;
    nvp->name = name;
}

boolean CGIrequest::dispatch()
{
    char lenbuf[4];
    if (!sock->read(lenbuf, sizeof lenbuf)) {
	return False;
    }
    nat4 length = unpack4(lenbuf);
    char* buf = new char[length - sizeof length];
    if (!sock->read(buf, length - sizeof length)) {
	return False;
    }
    char *src = buf + buf[0], *end = buf + length - sizeof length;
    while (src < end) { 
	char* name = src;
	char ch; 
	char* dst = src;
	while ((ch = *src++) != '=') { 
	    if (ch == '+') {
		ch = ' ';
	    } else if (ch == '%') { 
		ch = ((src[0] >= 'A' ? src[0] - 'A'+ 10 : src[0] - '0') << 4) |
		     (src[1] >= 'A' ? src[1] - 'A'+ 10 : src[1] - '0');
		src += 2;
	    }
	    *dst++ = ch;
	}
	*dst = '\0';
	char* value = dst = src;
	while ((ch = *src++) != '&') { 
	    if (ch == '+') {
		ch = ' ';
	    } else if (ch == '%') { 
		ch = ((src[0] >= 'A' ? src[0] - 'A'+ 10 : src[0] - '0') << 4) |
		     (src[1] >= 'A' ? src[1] - 'A'+ 10 : src[1] - '0');
		src += 2;
	    }
	    *dst++ = ch;
	}
	*dst = '\0';
	addPair(name, value);
    }
    char* page = get("page");
    if (page == NULL) {
	return False;
    }
    stub = get("stub");
    unsigned hash_code = string_hash_function(page);
    CGIapi::dispatcher* disp;
    for (disp = api->hash_table[hash_code % CGIapi::hash_table_size];
	 disp != NULL; 
	 disp = disp->collision_chain)
    {
	if (disp->hash_code == hash_code && strcmp(disp->page, page) == 0)
	{ 
	    boolean result = disp->func(*this);
	    pack4(reply_buf, reply_buf_used);
	    return sock->write(reply_buf, reply_buf_used) & result;
	}
    }
    return False;
}


char* CGIrequest::get(char const* name)
{
    unsigned hash_code = string_hash_function(name);
    name_value_pair* nvp;
    for (nvp = hash_table[hash_code % hash_table_size];
	 nvp != NULL; 
	 nvp = nvp->next)
    {
	if (nvp->hash_code == hash_code && strcmp(nvp->name, name) == 0) { 
	    return (char*)nvp->value;
	}
    }
    return NULL;
}
    



//--------------------------------------------------


CGIapi::CGIapi(int n_handlers, dispatcher* dispatch_table)
{
    memset(hash_table, 0, sizeof hash_table);
    sock = NULL;
    address = NULL;
    dispatcher* disp = dispatch_table;
    while (--n_handlers >= 0) { 
	unsigned hash_code = string_hash_function(disp->page);
	disp->hash_code = hash_code;
	hash_code %= hash_table_size;
	disp->collision_chain = hash_table[hash_code];
	hash_table[hash_code] = disp;
	disp += 1;
    }
}

boolean CGIapi::open(char const* socket_address, 
		     socket_t::socket_domain domain, 
		     int listen_queue)
{
    if (sock != NULL) { 
	close();
    }
    address = new char[strlen(socket_address) + 1];
    strcpy(address, socket_address);
    sock = domain != socket_t::sock_global_domain 
	? socket_t::create_local(socket_address, listen_queue)
	: socket_t::create_global(socket_address, listen_queue);
    return sock != NULL;
}




boolean CGIapi::get(CGIrequest& req)
{
    assert(sock != NULL);
    req.reset();
    req.sock = sock->accept();
    req.api = this;
    req.address = address;
    return req.sock != NULL;
}



void CGIapi::close()
{
    delete sock;
    delete[] address;
    sock = NULL;
}




