//-< CGIAPI.H >------------------------------------------------------*--------*
// GigaBASE                  Version 1.0         (c) 1999  GARRET    *     ?  *
// (Post Relational Database Management System)                      *   /\|  *
//                                                                   *  /  \  *
//                          Created:     27-Mar-99    K.A. Knizhnik  * / [] \ *
//                          Last update:  4-Apr-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Interface with WWW server 
//-------------------------------------------------------------------*--------*

#ifndef __CGIAPI_H__
#define __CGIAPI_H__

#include "stdtp.h"
#include "sockio.h"

enum CGIencodingType { 
    TAG  = 0, // HTML tags (no conversion)
    HTML = 1, // replace ('<','>','"','&') with (&lt; &gt; &amp; &qout;)
    URL  = 2  // replace spaces with '+', and other special characters with %XX
};
//
// Automatic state shifts after each append operation:
//   TAG->HTML
//   HTML->TAG
//   URL->TAG
//

class CGIrequest {  
    friend class CGIapi;
    
  public:
    void* userData;
    typedef bool (*handler)(CGIrequest& req);

    //
    // Append string to reply buffer
    //
    CGIrequest& append(char const* str);
    
    CGIrequest& operator << (char const* str) { 
	return append(str);
    }
    
    void setEncoding(CGIencodingType type) { encoding = type; }

    CGIrequest& operator << (CGIencodingType type) { 
	setEncoding(type);
	return *this;
    }
    CGIrequest& operator << (int value) { 
	char buf[32];
	sprintf(buf, "%d", value);
	return append(buf);
    }
    
    char* getStub() { return stub; }

    char* getAddress() { return address; }

    //
    // Compare content of the string with the end of the reply buffer
    //
    bool terminatedBy(char const* str) const;

    //
    // Call request handler
    //
    bool dispatch();    

    //
    // Get value of variable from request string. If name is not present in 
    // string NULL is returned
    //
    char* get(char const* name);
    
    //
    // Associatte value with name
    //
    void addPair(char const* name, char const* value);
    
    CGIrequest();
    ~CGIrequest();
  protected: 
    enum { hash_table_size = 1013 };
    socket_t*   sock;
    char*       request_buf;
    size_t      request_buf_size;
    CGIapi*     api;
    char*       reply_buf;
    size_t      reply_buf_size;
    size_t      reply_buf_used;
    char*       stub;
    char*       address;
    CGIencodingType encoding;
   

    struct name_value_pair { 
	name_value_pair* next;
	char const*      name;
	char const*      value;
	unsigned         hash_code;
    };

    name_value_pair* hash_table[hash_table_size];
    name_value_pair* free_pairs;

    char* extendBuffer(size_t inc);


    //
    // Deallocate all resources hold by request. It is not possible to 
    // call get_value() or reply() method after this. Method reset()
    // is implicitly called by CGIapi::get() method.
    //
    void reset();
};


class CGIapi { 
    friend class CGIrequest;
  public:
    struct dispatcher { 
	char const*         page;
	CGIrequest::handler func;
	// filled by contracutor of CGIapi
	unsigned            hash_code;
	dispatcher*         collision_chain;
    };

  protected:
    socket_t*   sock;
    char*       address;

    enum { hash_table_size = 113  };
    dispatcher* hash_table[hash_table_size];

  public:
    CGIapi(int n_handlers, dispatcher* dispatch_table);

    //
    // Bind and listen socket
    //
    bool open(char const* socket_address, 
	      socket_t::socket_domain domain = socket_t::sock_any_domain, 
	      int listen_queue = DEFAULT_LISTEN_QUEUE_SIZE);

    //
    // Accept new connection by the socket
    //
    bool get(CGIrequest& req);

    //
    // Close socket
    // 
    void close();
};

#endif

