//-< BTREE.CPP >-----------------------------------------------------*--------*
// GigaBASE                  Version 1.0         (c) 1999  GARRET    *     ?  *
// (Post Relational Database Management System)                      *   /\|  *
//                                                                   *  /  \  *
//                          Created:      1-Jan-99    K.A. Knizhnik  * / [] \ *
//                          Last update:  7-Jan-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// B-Tree interface
//-------------------------------------------------------------------*--------*

#ifndef __TTREE_H__
#define __TTREE_H__


const size_t dbMaxKeyLen = dbPageSize / 2;

class dbBtree : public dbRecord { 
  protected:
    oid_t root;
    int4  height;

  public:
    enum OperationEffect { 
	done,
	overflow,
	underflow,
	not_found,
	propagation
    };
	
    static oid_t allocate(dbDatabase* db);
    static void  find(dbDatabase* db, oid_t treeId, dbSearchContext& sc);
    static void  insert(dbDatabase* db, oid_t treeId, oid_t recordId, 
			int type, int offs);
    static void  remove(dbDatabase* db, oid_t treeId, oid_t recordId,
			int type, int offs);
    static void  drop(dbDatabase* db, oid_t treeId);
    static void  purge(dbDatabase* db, oid_t treeId);
    
    static void  traverseForward(dbDatabase* db, oid_t treeId,
				 dbAnyCursor* cursor, dbExprNode* condition);
    static void  traverseBackward(dbDatabase* db, oid_t treeId,
				  dbAnyCursor* cursor, dbExprNode* condition);
    static void  traverseForward(dbDatabase* db, oid_t treeId,
				 dbAnyCursor* cursor)
    {
	traverseForward(db, treeId, cursor, NULL);
    }
    static void  traverseBackward(dbDatabase* db, oid_t treeId,
				  dbAnyCursor* cursor)
    {
	traverseBackward(db, treeId, cursor, NULL);
    }
};


class dbBtreePage { 
  public:
    int4 m; // index of first elemtn at the page
    
    struct item { 
        oid_t  oid;
        pkey_t pkey;
    };
    enum { 
        maxItems = (dbPageSize - 4) / sizeof(item),
	minItems = maxItems/2
    };
    item e[maxItems];

    static oid_t allocate(dbDatabase* db, oid_t root, item& ins);
    
    static int insert(dbDatabase* db, oid_t pageId, oid_t lastPageId, 
		      int type, int offs, byte* p, item& ins, int height);
    static int remove(dbDatabase* db, oid_t pageId, oid_t lastPageId, 
		      int type, int offs, byte* p, item& rem, int height);

    int  handlePageUnderflow(dbDatabase* db, int r);
    int  handleLeafPageUnderflow(dbDatabase* db, int r, int type, 
				 oid_t lastPageId);
    
    static void purge(dbDatabase* db, oid_t pageId, int height);

    bool find(dbDatabase* db, dbSearchContext& sc, int height);

    bool traverseForward(dbDatabase* db, dbAnyCursor* cursor, 
			 dbExprNode* condition, int height);
    bool traverseBackward(dbDatabase* db, dbAnyCursor* cursor,
			  dbExprNode* condition, int height);
};

class dbBtreeLeafPage {
  public:
    nat4 nItems;
    nat4 size;
    
    enum { 
	maxItems = (dbPageSize - 8) / sizeof(oid_t)
    };

    struct str {
	oid_t oid;
	nat2  size;
	nat2  offs;
    };    

    union {
	oid_t  record[maxItems];
	int1   keyInt1[(dbPageSize-8) / sizeof(int1)];
	int2   keyInt2[(dbPageSize-8) / sizeof(int2)];
	int4   keyInt4[(dbPageSize-8) / sizeof(int4)];
	int8   keyInt8[(dbPageSize-8) / sizeof(int8)];
	real4  keyReal4[(dbPageSize-8) / sizeof(real4)];
	real8  keyReal8[(dbPageSize-8) / sizeof(real8)];
	char   keyChar[dbPageSize-8];
        str    keyStr[1];    
    };
    
    static oid_t allocate(dbDatabase* db, oid_t recordId, int type, int offs);
    
    static int   insert(dbDatabase* db, oid_t pageId, oid_t lastPageId, 
			int type, int offs, byte* p, dbBtreePage::item& ins);
    static int   remove(dbDatabase* db, oid_t pageId, oid_t lastPageId, 
			int type, int offs, byte* p, dbBtreePage::item& rem);

    void compactify(int m);
    
    bool find(dbDatabase* db, dbSearchContext& sc);

    bool traverseForward(dbDatabase* db, dbAnyCursor* cursor,
			 dbExprNode* condition);
    bool traverseBackward(dbDatabase* db, dbAnyCursor* cursor,
			  dbExprNode* condition);
};
  

#endif
