/* rfldnms.c
 *	dumps out a REFLEX RXD file field names to stdout
 */

static const char AUTHOR[] = "@(#)$Id: rfldnms.c,v 1.2 1999/09/24 00:04:36 rk Exp $";
#include <stdio.h>
#include "reflex.h"
/*
 *********************************************************************
 *
 *     This software is copyrighted by R.K.Owen,Ph.D. 1996
 *
 * The author, R.K.Owen, of this software is not liable for any
 * problems WHATSOEVER which may result from use  or  abuse  of
 * this software. The author, R.K.Owen, grants unlimited rights
 * to anyone who uses and modifies this  software  for  private
 * non-commercial  use  as  long  as  this copyright and rights
 * notice remains in this software and is made available to all
 * recipients of this software.
 *
 * last known email: rk@owen.sj.ca.us
 *                   libreflex@kooz.sj.ca.us
 *
 *********************************************************************
 */

extern int errno;

#define MAXERRBUF	1024

/*----------------------------------------------------------------------*/

void usage(char *PrgNm) {
	(void) fprintf(stderr,
"%s - dumps the REFLEX data field names to stdout in one of many formats\n"
"\n"
"usage: %s reflex_file.rxd [...] \n"
"\n",
			PrgNm, PrgNm);
}

int main(int argc, char **argv) {
	char *ProgName;
	FILE *ReflexFile;
	char *FileName;
	char ErrMessage[MAXERRBUF];
	RefHeader *ReflexFileHeader;
	char **FNvec;
	FieldDesc **FDvec;
	int FNnum, RECnum;
	VarLenBuf **RepTPvec;
	int i;

	ProgName = *argv++;
	if (*argv == (char *) NULL) {
		usage(ProgName);
		return 1;
	}
/* cycle through commandline list */
	while ((FileName = *argv++) != (char *) NULL) {

/* open file */
		if ((ReflexFile = fopen(FileName,"r")) == (FILE *) NULL) {
			(void) sprintf(ErrMessage,
				"%s - Could not open '%s'",
				ProgName, FileName);
			perror(ErrMessage);
		}
/* read & dump reflex file into vectors */
		if (BuildReflex(ReflexFile, &ReflexFileHeader, &FNvec,
		&FNnum, &FDvec, &RepTPvec, NULL, &RECnum, ErrMessage)) {
			(void) fprintf(stderr,"%s : %s for '%s'\n",
				ProgName, ErrMessage, FileName);
			continue;
		}

		(void) printf("FN num = %d\n", FNnum);
		for (i = 0; FNvec[i] != (char *)NULL ; ++i) {
			(void) printf("\t%.3d\t%s\n", i, FNvec[i]);
		}

		QuitReflex(&ReflexFileHeader, &FNvec, &FDvec, &RepTPvec, NULL);
		(void) fclose(ReflexFile);
	}
	return 0;
}
