/* reflex.h
  A p2c version of
	flexrec.pas	6/20/86    written by Joe Schrader
 */

#ifndef _REFLEX_H_
#  define _REFLEX_H_

#  include <limits.h>			/* need specific size info */
#  include <stdio.h>

#  if 0
#    define MEMDEBUG
#    include "librko.h"
#  endif

#  if INT_MAX == 32767			/* int   = 16bit */
	typedef int int2;
	typedef unsigned int uint2;
#  elif SHRT_MAX == 32767		/* short = 16bit */
	typedef short int2;
	typedef unsigned short uint2;
#  else
#    error No appropriate 16bit integer
#  endif

#  if LONG_MAX == 2147483647		/* long  = 32bit */
	typedef long long4;
#  elif INT_MAX == 2147483647		/* int   = 32bit */
	typedef int long4;
#  else
#    error No appropriate 32bit integer
#  endif

#  define SkipSize        6

typedef unsigned char uchar;

/* SectionDesc size needs to be 10 bytes */
typedef struct SectionDesc {
	int2  SectionType;
	long4 SectionAddr;
	long4 SectionLen;
} SectionDesc;

/* types of sections described in SectionDesc */

#  define NUM_SECTIONS		12

extern const char *SectionNameStr[NUM_SECTIONS];

typedef enum {
	FieldDir, MasterRec, DataRecs, GFilter, GMode, OverVec, ViewState,
	ViewScale, FormView, ListView, CrossTab, GraphView
} SectionNames;

extern const int2 Sections[NUM_SECTIONS];

/* Fixed size Reflex file header we are mainly interested in the
   DfSection field which has the addresses for the other sections
   of the file */

/* RefHeader size needs to be 512 bytes */
typedef struct RefHeader {
	int2 HdrSz;
	char Stamp[12];				/* = "3Q.!&@#$!&&" */
	int2 Dirty, VerViews, VerModels, VerData, fRecalc;
	/* If error set fRecalc so that Reflex will recalculate */
	uchar ScreenType, CheckSum, Reserved[38];
/* everything above = 64 bytes */
	int2 SectionCt;
	SectionDesc DfSection[44];
	char buffer[6];
} RefHeader;

typedef struct VarLenBuf {
	/* represents a variable length buffer */
	int2 Len;		/* length of the buffer */
	uchar *Buf;		/* pointer to the buffer, use malloc */
} VarLenBuf;

typedef struct FieldDesc {
	int2 NameOffset;
	uchar DataType, PrecForm;
	int2 FieldOffset;
	long4 Index, Pool;
	/* IsDescending, */
	uchar SortPos, Reserved;
} FieldDesc;

typedef enum {Untyped, LocalText, RepText, Date, Numeric, IntVal} DataType;

extern const char *DataFields[6];

int BuildReflex(FILE *ReflexFile, RefHeader **ReflexFileHeader,
	char ***FNvec, int *FNnum, FieldDesc ***FDvec, VarLenBuf ***RepTPvec,
	VarLenBuf ***DataRecsVec, int *RECnum, char *ErrMsg);
void QuitReflex(RefHeader **ReflexFileHeader,
	char ***FNvec, FieldDesc ***FDvec, VarLenBuf ***RepTPvec,
	VarLenBuf ***DataRecsVec);

int ReadReflexHeader(FILE *In, RefHeader *H, char *ErrMsg);
int BuildReflexHeader(FILE *In, RefHeader **H, char *ErrMsg);
void QuitReflexHeader(RefHeader **R);
int GetSectionAddr(RefHeader *Header, SectionNames CurSection,
			long4 *SecAddr, long4 *SecLen, char *ErrMsg);
int BuildBuffer(FILE *In, VarLenBuf *B, char *ErrMsg);
void QuitBuffer(VarLenBuf *B);
char *PasteMessage(char *premsg, char *buffer);
const char *SectionName(int2 SV);

int GetFieldNameTbls(FILE *In, VarLenBuf *FieldNameIndex,
	VarLenBuf *FieldNameText, VarLenBuf *FieldDirectory, char *ErrMsg);
int ReadFieldDirDesc(VarLenBuf *FieldDirectory, int WhichOne, FieldDesc *F);
int BuildFieldNameVec(FILE *ReflexFile, RefHeader *ReflexFileHeader,
	int *FNc, char ***FNvec, FieldDesc ***FDvec, VarLenBuf ***RepTextPool,
	char *ErrMsg);
void QuitFieldNameVec(char ***FNvec, FieldDesc ***FDvec, VarLenBuf ***RepTPvec);
int BuildMasterRecord(FILE *ReflexFile, RefHeader *ReflexFileHeader,
	int *RECc, char *ErrMsg);
int BuildDataRecordsVec(FILE *ReflexFile, RefHeader *ReflexFileHeader,
	int RECc, VarLenBuf ***Dvec, char *ErrMsg);
void QuitDataRecordsVec(VarLenBuf ***Dvec);
void *OutputDataType(char *format, FieldDesc *FD, VarLenBuf **RepTPvec,
	VarLenBuf *D, char * ErrMsg);
#endif /* _REFLEX_H_ */
