/* refldump.c
 *	verbosely dumps out a REFLEX RXD file to stdout
 */

static const char AUTHOR[] = "@(#)$Id: refldump.c,v 1.2 1999/09/24 00:04:36 rk Exp $";
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "reflex.h"
/*
 *********************************************************************
 *
 *     This software is copyrighted by R.K.Owen,Ph.D. 1995
 *
 * The author, R.K.Owen, of this software is not liable for any
 * problems WHATSOEVER which may result from use  or  abuse  of
 * this software. The author, R.K.Owen, grants unlimited rights
 * to anyone who uses and modifies this  software  for  private
 * non-commercial  use  as  long  as  this copyright and rights
 * notice remains in this software and is made available to all
 * recipients of this software.
 *
 * last known email: rk@owen.sj.ca.us
 *                   libreflex@kooz.sj.ca.us
 *
 *********************************************************************
 */

extern int errno;

#define MAXERRBUF	1024

/*----------------------------------------------------------------------*/
void DumpFileName(FILE *output, char *name) {
  (void) fprintf(output,"----- File Name Info -----\n");
  (void) fprintf(output,"Name            = %s\n", name);
} 

void DumpSectionDesc(FILE *output, int num, SectionDesc *SD) {
  (void) fprintf(output,"----- Section Description %2.2d Info -----\n", num);
  (void) fprintf(output,"Section Type    = %ld\t%s\n", (long) SD->SectionType,
		SectionName(SD->SectionType));
  (void) fprintf(output,"Section Address = %ld\t0%lo\n",
		(long) SD->SectionAddr, (long) SD->SectionAddr);
  (void) fprintf(output,"Section Length  = %ld\t0x%lx\n",
		(long) SD->SectionLen, (long) SD->SectionLen);
}

void DumpHeader(FILE *output, RefHeader *H) {
	int i;
  (void) fprintf(output,"----- Header Info -----\n");
  (void) fprintf(output,"Header Size     = %ld\n", (long) H->HdrSz);
  (void) fprintf(output,"Stamp String    = %s\n", H->Stamp);
  (void) fprintf(output,"Dirty           = %ld\n", (long) H->Dirty);
  (void) fprintf(output,"VerViews        = %ld\n", (long) H->VerViews);
  (void) fprintf(output,"VerModels       = %ld\n", (long) H->VerModels);
  (void) fprintf(output,"VerData         = %ld\n", (long) H->VerData);
  (void) fprintf(output,"Force Recalc    = %ld\n", (long) H->fRecalc);
  (void) fprintf(output,"Dirty           = %ld\n", (long) H->Dirty);
  (void) fprintf(output,"ScreenType      = %ud\n", (unsigned) H->ScreenType);
  (void) fprintf(output,"Check Sum       = %ud\n", (unsigned) H->CheckSum);
  (void) fprintf(output,"Section Count   = %ld\n", (long) H->SectionCt);
	for (i = 0; i < H->SectionCt; ++i)
		DumpSectionDesc(output, i, &(H->DfSection[i]));
}

void DumpFieldDir(FILE *output, RefHeader *H) {
  long4 SecAddr, SecLen;
  char ErrMessage[100];
  (void) fprintf(output,"----- Field Directory Info -----\n");
  if (GetSectionAddr(H, FieldDir, &SecAddr, &SecLen, ErrMessage)) {
	(void) fprintf(output,"ERROR : %s\n", ErrMessage);
	return;
  }
  (void) fprintf(output,"Section Address = %ld\t0%lo\n",
		(long) SecAddr, (long) SecAddr);
  (void) fprintf(output,"Section Length  = %ld\t0x%lx\n",
		(long) SecLen, (long) SecLen);
}

void DumpFieldNameTbls(FILE *in, FILE *out) {
	VarLenBuf FieldNameIndex;
	VarLenBuf FieldNameText;
	VarLenBuf FieldDirectory;
	char ErrorMessage[100];
	int i;
	char *ptr;
	int2 off;

  (void) fprintf(out,"----- Field Name Info -----\n");
	if (GetFieldNameTbls(in, &FieldNameIndex,
		&FieldNameText, &FieldDirectory, ErrorMessage)) {
		(void) fprintf(out,"ERROR : %s\n", ErrorMessage);
	}
  (void) fprintf(out,"Index Length    = %ld\n", (long) FieldNameIndex.Len);
  (void) fprintf(out,"Text  Length    = %ld\n", (long) FieldNameText.Len);
  (void) fprintf(out,"Directory Length= %ld\n", (long) FieldDirectory.Len);
	for (i = 0; i < ((FieldNameIndex.Len / 2) & 255); ++i) {
		off = *(FieldNameIndex.Buf + 2*i);
		memcpy(&off, FieldNameIndex.Buf + 2*i, 2);
		ptr = FieldNameText.Buf + off;
		(void) fprintf(out,"\t%3.3d\t%s\n", i, ptr);
	}
}

void DumpFD(FILE *out, int n, FieldDesc *FD) {
	if (FD == (FieldDesc *) NULL) {
		(void) fprintf(out,"%.3d---NULL------=\n", n);
		return;
	}
  (void) fprintf(out,"%.3d.Name Offset = %ld\n", n, (long) FD->NameOffset);
  (void) fprintf(out,"%.3d.Data Type   = %ld\t%s\n", n, (long) FD->DataType,
		DataFields[FD->DataType]);
  (void) fprintf(out,"%.3d.Prec Form   = %ld\n", n, (long) FD->PrecForm);
  (void) fprintf(out,"%.3d.Field Offset= 0x%lx\n", n, (long) FD->FieldOffset);
  (void) fprintf(out,"%.3d.Index       = 0x%lx\n", n, (long) FD->Index);
  (void) fprintf(out,"%.3d.Pool        = 0x%lx\n", n, (long) FD->Pool);
  (void) fprintf(out,"%.3d.Sort Pos    = 0x%lx\n", n, (long) FD->SortPos);
  (void) fprintf(out,"%.3d.Reserved    = %ld\n", n, (long) FD->Reserved);
}

void DumpMR(FILE *output, int RECnum) {
  (void) fprintf(output,"----- Master Record Info -----\n");
  (void) fprintf(output,"Num of Records  = %d\n", RECnum);
} 

void DumpDR(FILE *out, char *header, int RECnum, VarLenBuf **DR) {
	int i=0, j;
	(void) fprintf(out,"----- %s Info -----\n", header);
	
	do {
		if (DR[i] != (VarLenBuf *) NULL) {
			(void) fprintf(out, " %.3d :", i);
			for (j = 0; j < DR[i]->Len; ++j) {
				(void) fprintf(out," %3.3o", DR[i]->Buf[j]);
			}
			(void) fprintf(out,"\n");
		} else {
			(void) fprintf(out," %.3d---NULL------=\n", i);
		}
	} while (DR[i++] != (VarLenBuf *) NULL);
} 

void DumpDRf(FILE *out, int num, char **FNvec, FieldDesc **FDvec, VarLenBuf **RepTPvec,
			VarLenBuf *D) {
	char ErrMsg[200];
	char format[6][20] = {
		"None",		/* Untyped */
		"%s",		/* LocalText */
		":%s:",		/* RepText */
		"%m/%d/%Y %a %j",	/* Date */
		"%g",		/* Numeric */
		"%d"};		/* intval */
	char *fptr;
	char *optr;
	int i = 0;

	while (FNvec[i] != (char *) NULL) {
		(void) fprintf(out, "%03d : %s :", num, FNvec[i]);
		fptr = format[FDvec[i]->DataType];
		optr = OutputDataType(fptr, FDvec[i], RepTPvec, D, ErrMsg);
		if (optr != (char *) NULL) (void) fprintf(out, "%s\n", optr);
		else (void) fprintf(out, "%s\n", ErrMsg);
		++i;
	}
}

/*----------------------------------------------------------------------*/

void usage(char *PrgNm) {
	(void) fprintf(stderr,
"%s - verbosely dumps a REFLEX data file to stdout\n"
"\n"
"usage: %s reflex_file.rxd [...] \n"
"\n",
			PrgNm, PrgNm);
}

int main(int argc, char **argv) {
	char *ProgName;
	FILE *ReflexFile;
	char *FileName;
	char ErrMessage[MAXERRBUF];
	RefHeader *ReflexFileHeader;
	char *ptr;
	char **FNvec;
	FieldDesc *FDptr;
	FieldDesc **FDvec;
	int FNnum, RECnum;
	VarLenBuf **RepTPvec;
	VarLenBuf **DataRecsVec;
	int i;

	ProgName = *argv++;
	if (*argv == (char *) NULL) {
		usage(ProgName);
		return 1;
	}
	printf("sizeof RefHeader   = %d\n", sizeof(RefHeader));
	printf("sizeof SectionDesc = %d\n", sizeof(SectionDesc));
	printf("sizeof uchar       = %d\n", sizeof(uchar));
	printf("sizeof int2        = %d\n", sizeof(int2));
	printf("sizeof long4       = %d\n", sizeof(long4));
/* cycle through commandline list */
	while ((FileName = *argv++) != (char *) NULL) {

/* open file */
		if ((ReflexFile = fopen(FileName,"r")) == (FILE *) NULL) {
			(void) sprintf(ErrMessage,
				"%s - Could not open '%s'",
				ProgName, FileName);
			perror(ErrMessage);
		}
		DumpFileName(stdout, FileName);
/* Read Header */
		if (BuildReflexHeader(ReflexFile, &ReflexFileHeader,
			ErrMessage)) {
			(void) fprintf(stderr,"%s : %s for '%s'\n",
				ProgName, ErrMessage, FileName);
			continue;
		}
/* Dump Header */
		DumpHeader(stdout, ReflexFileHeader);
/* Dump Field Descriptor */
		DumpFieldDir(stdout, ReflexFileHeader);
		DumpFieldNameTbls(ReflexFile, stdout);

		if (BuildFieldNameVec(ReflexFile, ReflexFileHeader,
			&FNnum, &FNvec, &FDvec, &RepTPvec,
			ErrMessage)) {
			(void) fprintf(stderr, "%s\n", ErrMessage);
			continue;
		}
		(void) printf("FN num = %d\n", FNnum);
		i = 0;
		do {
			ptr = FNvec[i];
			(void) printf("\t%.3d\t%s\n", i++, ptr);
		} while (ptr != (char *)NULL);
		i = 0;
		do {
			FDptr = FDvec[i];
			DumpFD(stdout, i++, FDptr);
		} while (FDptr != (FieldDesc *)NULL);

		DumpDR(stdout, "RepText Pool", RECnum, RepTPvec);

		if (BuildMasterRecord(ReflexFile, ReflexFileHeader,
			&RECnum, ErrMessage)) {
			(void) fprintf(stderr, "%s\n", ErrMessage);
			continue;
		}
		DumpMR(stdout, RECnum);
		if (BuildDataRecordsVec(ReflexFile, ReflexFileHeader,
			RECnum, &DataRecsVec, ErrMessage)) {
			(void) fprintf(stderr, "%s\n", ErrMessage);
			continue;
		}
		DumpDR(stdout, "Data Records", RECnum, DataRecsVec);
		for (i = 0; i < RECnum; ++i) {
			DumpDRf(stdout, i, FNvec, FDvec, RepTPvec,
			DataRecsVec[i]);
		}
		QuitReflex(&ReflexFileHeader, &FNvec, &FDvec, &RepTPvec,
			&DataRecsVec);

		(void) fclose(ReflexFile);
	}
	return 0;
}
