static const char AUTHOR[] = "@(#)$Id: outdaty.c,v 1.2 1999/09/24 00:04:36 rk Exp $";
#include <stdio.h>
#include <time.h>
#include <string.h>
#include "reflex.h"
/*
 *********************************************************************
 *
 *     This software is copyrighted by R.K.Owen,Ph.D. 1995
 *
 * The author, R.K.Owen, of this software is not liable for any
 * problems WHATSOEVER which may result from use  or  abuse  of
 * this software. The author, R.K.Owen, grants unlimited rights
 * to anyone who uses and modifies this  software  for  private
 * non-commercial  use  as  long  as  this copyright and rights
 * notice remains in this software and is made available to all
 * recipients of this software.
 *
 * last known email: rk@owen.sj.ca.us
 *                   libreflex@kooz.sj.ca.us
 *
 *********************************************************************
 */

#define MAXDATASIZE	256
#define NULLOUT		(void *) NULL;

static char OutputBuffer[MAXDATASIZE];
static uint2 NULL_DATE			= 0;
static unsigned char  NULL_INTVAL[2]	= { 0x00, 0x80};
static unsigned char NULL_NUMERIC[8]	= { 0x00, 0x00, 0x00, 0x00,
					    0x00, 0x00, 0xFF, 0x7F};

static void ClearBuffer(void) {
	(void) memset(OutputBuffer, 0, MAXDATASIZE);
}

/* Reflex stores dates as the number of days since 12/31/1899
 * (e.g. 01/01/1900 =     1	- first allowed date
 *       06/04/2079 = 65534	- last  allowed date)
 * Reflex correctly denies 02/29/1900 and accepts 02/29/2000 as valid dates
 */
static struct tm * ReflexDate(unsigned int RD) {
	static struct tm Save;
	unsigned int yr, mn, dy;
	long t;
	int leapyr = 0;

/* calendar formulas are from "Astronomical Algorithms" by Jean Meeus (c) 1991
 *	pages 63-65
 */
	long a, aa, b, c, d, e;
	int jd, dw;

	t = (long) RD + 2415020L;	/* JD for 01/01/1900 */
	aa = (100L * t - 186721625L) / 3652425L;
	a = t + 1L + aa - aa/4L;
	b = a + 1524L;
	c = (100L * b - 12210L) / 36525L;
	d = (36525L * c) / 100L;
	e = (100L *(b - d)) / 3061L;

	dy = (int) (b - d - ((3061L * e)/100L));
	mn = (int) (e - (e < 14L ? 1L : 13L));
	yr = c - 4715 - (mn > 2 ? 1 : 0);

	if ((yr%4) == 0) {
		leapyr = 1;
	}
	if (yr == 1900) {
		leapyr = 0;
	}
	jd = (275 * mn) / 9 - (leapyr == 0 ? 2 : 1) * ((mn + 9)/ 12) + dy - 30;
	dw = (int) (t + 1L)%7L;

	Save.tm_sec = 0;
	Save.tm_min = 0;
	Save.tm_hour = 12;
	Save.tm_mday = dy;
	Save.tm_mon = mn - 1;
	Save.tm_year = yr - 1900;
#if 1
	/* fill entire documented "struct tm" since some mktime()s are
	 * "broken".  (They barf on valid dates ... I found this with the
	 * gnu gcc compiler on linux
	 */
	Save.tm_wday = dw;
	Save.tm_yday = jd - 1;
	Save.tm_isdst = -1;
	return &Save;
#else
	if (mktime(&Save) == (time_t) -1) {
		return (struct tm *) NULL;
	} else {
		return &Save;
	}
#endif
}

void * OutputDataType(char *format, FieldDesc *FD, VarLenBuf **RepTPvec,
	VarLenBuf *D, char * ErrMsg) {

	char *ptr;
	uint2 offset;
	long4 loffset;
	uint2 dateval;
	struct tm *dateptr;
	float fnum;
	double dnum;
	long double ldnum;
	void * numptr;
	int2 intval;

/* this is the only exception to the ErrMsg mechanism */
/* check if return is NULL and ErrMsg is not null for error */
	*ErrMsg = '\0';
	ClearBuffer();
/* if format == (char *)NULL then output raw data else ASCII text */
	switch (FD->DataType) {
	case Untyped :
		(void) strcpy(ErrMsg, "OutputDataType : untyped data type");
		return NULLOUT;
	case LocalText :
		(void) memcpy(&offset, D->Buf + FD->FieldOffset, sizeof(uint2));
		if (offset == 0) return NULLOUT;
		ptr = D->Buf + offset;
		if (format == (char *) NULL) {
			(void) strcpy(OutputBuffer, ptr);
		} else {
			(void) sprintf(OutputBuffer, format, ptr);
		}
		return (void *) OutputBuffer;
	case RepText :
		(void) memcpy(&offset, D->Buf + FD->FieldOffset, sizeof(uint2));
		if (offset == 0) return NULLOUT;
		(void) memcpy(&loffset, &(FD->Index), sizeof(long4));
		ptr = RepTPvec[loffset]->Buf + offset;
		if (format == (char *) NULL) {
			(void) strcpy(OutputBuffer, ptr);
		} else {
			(void) sprintf(OutputBuffer, format, ptr);
		}
		return (void *) OutputBuffer;
	case Date :
		(void) memcpy(&dateval, D->Buf + FD->FieldOffset, sizeof(uint2));
		if (!memcmp(&dateval, &NULL_DATE, sizeof(uint2))) return NULLOUT;
		if ((dateptr = ReflexDate((unsigned int) dateval)) ==
			(struct tm *) NULL) {
			(void) strcpy(ErrMsg,
				"OutputDataType : numeric type error");
			return NULLOUT;
		}
		if (format == (char *) NULL) {
			(void) memcpy(OutputBuffer, dateptr, sizeof(struct tm));
		} else if (!strcmp(format, "%raw")) {
			(void) memcpy(OutputBuffer, &dateval, sizeof(uint2));
		} else {
			(void) strftime(OutputBuffer, MAXDATASIZE,
				format, dateptr);
		}
		return (void *) OutputBuffer;
	case Numeric :
		if (sizeof (float) == 8) {
			numptr = &fnum;
		} else if (sizeof (double) == 8) {
			numptr = &dnum;
		} else if (sizeof (long double) == 8) {
			numptr = &ldnum;
		} else {
			(void) strcpy(ErrMsg,
				"OutputDataType : numeric type error");
			return NULLOUT;
		}
		(void) memcpy(numptr, D->Buf + FD->FieldOffset, 8);
		if (!memcmp(numptr, &NULL_NUMERIC, 8)) return NULLOUT;
		if (format == (char *) NULL) {
			(void) memcpy(OutputBuffer, numptr, 8);
		} else {
			if (sizeof (float) == 8) {
				(void) sprintf(OutputBuffer, format, fnum);
			} else if (sizeof (double) == 8) {
				(void) sprintf(OutputBuffer, format, dnum);
			} else if (sizeof (long double) == 8) {
				(void) sprintf(OutputBuffer, format, ldnum);
			}
		}
		return (void *) OutputBuffer;
	case IntVal :
		(void) memcpy(&intval, D->Buf + FD->FieldOffset, sizeof(int2));
		if (!memcmp(&intval, &NULL_INTVAL, sizeof(int2))) return NULLOUT;
		if (format == (char *) NULL) {
			(void) memcpy(OutputBuffer, &intval, sizeof(int2));
		} else {
			(void) sprintf(OutputBuffer, format, intval);
		}
		return (void *) OutputBuffer;
	default :
		(void) strcpy(ErrMsg, "OutputDataType : data type error");
		return NULLOUT;
	}
}
