.\" USMID %W%
.\" LIBREFLEX
.TH "LIBREFLEX" "3" "21 September 1999"
.SH NAME
libreflex \- a collection of routines for reading a Borland Reflex database file

.SH SYNOPSIS
.I Reflex
is a flat file database DOS program from Borland Software.
It's a really spiffy database for keeping track of addresses, video movie titles,
Perry Mason episode names, etc.  For most people a relational database is
too much power, too much expense, too much complexity to keep track of your
friends' telephone numbers.  I doublt Borland, or it's spin-offs,
even sells it anymore, but these routines were created to read a
.I Reflex
\.RXD file and parse out the appropriate data for a label printing program.
The database file is updated and maintained by 
.IR Reflex ,
and the label generator reads the database file.

.nf
#include "reflex.h"

typedef struct RefHeader {
	int2 HdrSz;
	char Stamp[12];			/* = "3Q.!&@#$!&&" */
	int2 Dirty, VerViews, VerModels, VerData, fRecalc;
	uchar ScreenType, CheckSum, Reserved[38];
/* everything above = 64 bytes */
	int2 SectionCt;
	SectionDesc DfSection[44];
	char buffer[6];
} RefHeader;

typedef struct VarLenBuf {
	/* represents a variable length buffer */
	int2 Len;	/* length of the buffer */
	uchar *Buf;	/* pointer to the buffer, use malloc */
} VarLenBuf;

typedef struct FieldDesc {
	int2 NameOffset;
	uchar DataType, PrecForm;
	int2 FieldOffset;
	long4 Index, Pool;
	/* IsDescending, */
	uchar SortPos, Reserved;
} FieldDesc;

typedef enum {Untyped, LocalText, RepText, Date, Numeric, IntVal} DataType;

int BuildReflex(FILE *ReflexFile, RefHeader **ReflexFileHeader,
	char ***FNvec, int *FNnum, FieldDesc ***FDvec,
	VarLenBuf ***RepTPvec, VarLenBuf ***DataRecsVec,
	int *RECnum, char *ErrMsg);
void QuitReflex(RefHeader **ReflexFileHeader,
	char ***FNvec, FieldDesc ***FDvec, VarLenBuf ***RepTPvec,
	VarLenBuf ***DataRecsVec);

int BuildReflexHeader(FILE *In, RefHeader **H, char *ErrMsg);
void QuitReflexHeader(RefHeader **R);
int BuildBuffer(FILE *In, VarLenBuf *B, char *ErrMsg);
void QuitBuffer(VarLenBuf *B);

int BuildFieldNameVec(FILE *ReflexFile, RefHeader *ReflexFileHeader,
	int *FNc, char ***FNvec, FieldDesc ***FDvec,
	VarLenBuf ***RepTextPool, char *ErrMsg);
void QuitFieldNameVec(char ***FNvec, FieldDesc ***FDvec,
	VarLenBuf ***RepTPvec);

int BuildMasterRecord(FILE *ReflexFile, RefHeader *ReflexFileHeader,
	int *RECc, char *ErrMsg);
int BuildDataRecordsVec(FILE *ReflexFile, RefHeader *ReflexFileHeader,
	int RECc, VarLenBuf ***Dvec, char *ErrMsg);
void QuitDataRecordsVec(VarLenBuf ***Dvec);

char *PasteMessage(char *premsg, char *buffer);
const char *SectionName(int2 SV);
void *OutputDataType(char *format, FieldDesc *FD,
	VarLenBuf **RepTPvec, VarLenBuf *D, char * ErrMsg);

.fi

.SH DESCRIPTION
.I libreflex
uses the convention that ``Build'' routines allocate memory
for various variable length vectors, and ``Quit'' routines free
this memory.  Note that a vector is an array terminated by a
NULL element, and the ErrMsg string buffer is used to paste
in error messages that may occur.
Most of the routines return zero on success, and -1 if an error occured.
.P
Two functions are the omnibus routines that can handle most
tasks for a Reflex database file.
The various vectors used are:
.nf
	FNvec       - field name vector,
	FDvec       - field descriptor vector,
	RepTPvec    - repetative text pool vector,
	DataRecsVec - the actual data records.
.fi

.TP 20
BuildReflex
reads the Reflex database file creating all the vectors as need.
However, if DataRecsVec is NULL, then it will skip reading all the
data records.
.TP
QuitReflex
frees up the memory used

.TP
PasteMessage
a utility routine to simple-mindedly prepend some text before
the error message (usually passed up from a lower level routine).

.TP
SectionName
returns a string pointer to a section name

.TP
OutputDataType
returns a string pointer to an internal location that contains
the record element formatted according to the given format.

.P
The following
.I libreflex
routines are on level below the omnibus routines and may need
to be called for special circumstances and handling.
They also generally need to be called in the given order:
.TP 20
BuildReflexHeader
a necessary routine that reads the
.I Reflex
database file header.  Fills in a
.I RefHeader
structure.

.TP
BuildFieldNameVec
fills in field name vector, field descriptor vector,
and repeative text pool vector.

.TP
BuildMasterRecord
reads the ``master record'' to obtain the record count.

.TP
BuildDataRecordsVec
the work-horse routine that reads all the records into a vector of
variable length buffers
.RI ( VarLenBuf ).

.TP
BuildDataRecordsVec
releases the data record vector.
.TP
BuildFieldNameVec
releases the field name and descriptor vectors.
.TP
BuildReflexHeader
releases the header block.

.SH SEE ALSO
reflex(1)

.SH NOTES
The library was loosely based on a Pascal version written by Joe Schrader,
but it no longer bears any close resemblence anymore.

.SH DIAGNOSTICS
Most routines return a non-zero value if there is an error and pastes a message
into the error message buffer.  None of the routines check to see if they
have overwritten the end of the buffer, which could cause memory corruption.
Recommend a string buffer of at least length 1024.

.SH BUGS
Probably has a few, but seems to work just as is.

.SH AUTHOR
R.K.Owen,Ph.D.

.KEY WORDS
