static const char AUTHOR[] = "@(#)$Id: getsecadr.c,v 1.2 1999/09/24 00:04:36 rk Exp $";
#include <string.h>
#include "reflex.h"
/*
 *********************************************************************
 *
 *     This software is copyrighted by R.K.Owen,Ph.D. 1995
 *
 * The author, R.K.Owen, of this software is not liable for any
 * problems WHATSOEVER which may result from use  or  abuse  of
 * this software. The author, R.K.Owen, grants unlimited rights
 * to anyone who uses and modifies this  software  for  private
 * non-commercial  use  as  long  as  this copyright and rights
 * notice remains in this software and is made available to all
 * recipients of this software.
 *
 * last known email: rk@owen.sj.ca.us
 *                   libreflex@kooz.sj.ca.us
 *
 *********************************************************************
 */

int GetSectionAddr(RefHeader *Header, SectionNames CurSection,
			long4 *SecAddr, long4 *SecLen, char *ErrMsg) {
	int i = 0;
	int SectionFound;

	do {
		if ((SectionFound = (Header->DfSection[i].SectionType
				== Sections[CurSection]))) {
			*SecAddr = Header->DfSection[i].SectionAddr;
			*SecLen = Header->DfSection[i].SectionLen;
		}
		++i;
	} while (i < Header->SectionCt && ! SectionFound);
	if (!SectionFound) {
		strcpy(ErrMsg,"GetSectionAddr: No section found");
		return -1;
	}
	return 0;
}
