static const char AUTHOR[] = "@(#)$Id: bldfnvec.c,v 1.2 1999/09/24 00:04:36 rk Exp $";
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "reflex.h"

/*
 *********************************************************************
 *
 *     This software is copyrighted by R.K.Owen,Ph.D. 1995
 *
 * The author, R.K.Owen, of this software is not liable for any
 * problems WHATSOEVER which may result from use  or  abuse  of
 * this software. The author, R.K.Owen, grants unlimited rights
 * to anyone who uses and modifies this  software  for  private
 * non-commercial  use  as  long  as  this copyright and rights
 * notice remains in this software and is made available to all
 * recipients of this software.
 *
 * last known email: rk@owen.sj.ca.us
 *                   libreflex@kooz.sj.ca.us
 *
 *********************************************************************
 */

extern int errno;

int BuildFieldNameVec(FILE *ReflexFile, RefHeader *ReflexFileHeader,
	int *FNc, char ***FNvec, FieldDesc ***FDvec, VarLenBuf ***RepTPvec,
	char *ErrMsg) {
/* Creates a Field Name Vector ... assumes nothing about file position */

	VarLenBuf FieldNameIndex;
	VarLenBuf FieldNameText;
	VarLenBuf FieldDirectory;
	VarLenBuf temp;
	int i, j, len, numRepText = 0;
	char *ptr;
	long4 SecAddr, SecLen;

/* Get Field Directory address from Header */
	if (GetSectionAddr(ReflexFileHeader, FieldDir, &SecAddr, &SecLen,
		ErrMsg)) {
		(void) PasteMessage("BuildFieldNameVec : ", ErrMsg);
		return -1;
	}
	if (fseek(ReflexFile, SecAddr, SEEK_SET)) {
		(void) strcpy(ErrMsg, "BuildFieldNameVec : fseek error :");
		(void) strcat(ErrMsg, strerror(errno));
		return -1;
	}
	if (GetFieldNameTbls(ReflexFile, &FieldNameIndex,
		&FieldNameText, &FieldDirectory, ErrMsg)) {
		(void) PasteMessage("BuildFieldNameVec : ", ErrMsg);
		return -1;
	}
	/* number of entries in vector */
	*FNc = ((FieldNameIndex.Len / 2) & 255);

	/* alloc space for vectors */

	/* get FDvec memory space set up */
	if ((*FDvec = (FieldDesc **) malloc((*FNc + 1) * sizeof(FieldDesc *)))
		== (FieldDesc **) NULL) {
		(void) strcpy(ErrMsg, "BuildFieldNameVec : FDvec* malloc error");
		return -1;
	}
	for (i = 0; i < *FNc; ++i) {
		if (((*FDvec)[i] = (FieldDesc *) malloc(sizeof(FieldDesc)))
			== (FieldDesc *) NULL) {
			(void) strcpy(ErrMsg,
				"BuildFieldNameVec : FDvec malloc error");
			return -1;
		}
		if (ReadFieldDirDesc(&FieldDirectory, i, (*FDvec)[i])) {
			(void) strcpy(ErrMsg,
				"BuildFieldNameVec : FDvec read FDD error");
			return -1;
		}
		if ((*FDvec)[i]->DataType == RepText) {
			++numRepText;
		}
	}
	(*FDvec)[*FNc] = (FieldDesc *) NULL;

	if ((*FNvec = (char **) malloc((*FNc + 1) * sizeof(char *)))
		== (char **) NULL) {
		(void) strcpy(ErrMsg, "BuildFieldNameVec : FNvec malloc error");
		return -1;
	}

	for (i = 0; i < *FNc; ++i) {
		ptr = FieldNameText.Buf + (*FDvec)[i]->NameOffset;
		len = strlen(ptr);
		if (((*FNvec)[i] = (char *) malloc((len + 1) * sizeof(char)))
			== (char *) NULL) {
			(void) strcpy(ErrMsg,
				"BuildFieldNameVec : FNvec char malloc error");
			return -1;
		}
		(void) strcpy((*FNvec)[i], ptr);
	}
	(*FNvec)[*FNc] = (char *) NULL;

	/* allocate space for RepText pool */
	if ((*RepTPvec = (VarLenBuf **) malloc(numRepText *
		sizeof(VarLenBuf *))) == (VarLenBuf **) NULL) {
		(void) strcpy(ErrMsg,
			"BuildFieldNameVec : RepText Pool * malloc error");
		return -1;
	}
	for (i = 0; i < numRepText; ++i) {
		if (((*RepTPvec)[i] = (VarLenBuf *) malloc(
			sizeof(VarLenBuf))) == (VarLenBuf *) NULL) {
			(void) strcpy(ErrMsg,
			"BuildFieldNameVec : RepText Pool malloc error");
			return -1;
		}
	}
	(*RepTPvec)[numRepText] = (VarLenBuf *) NULL;

	/* skip 6 bytes */
	if (fseek(ReflexFile, 6, SEEK_CUR)) {
		(void) strcpy(ErrMsg, "BuildFieldNameVec : fseek skip error :");
		(void) strcat(ErrMsg, strerror(errno));
		return -1;
	}
	/* read the RepText pool */
	for (i = 0; i < numRepText; ++i) {
		/* skip over text ptrs ... don't need them */
		if (BuildBuffer(ReflexFile, &temp, ErrMsg)) {
			(void) PasteMessage("BuildFieldNameVec : temp error: ",
				ErrMsg);
			return -1;
		}
		QuitBuffer(&temp);

		/* read RepText pool ... note that is contains more info */
		/* like how many data vecs reference given text pool item */
		if (BuildBuffer(ReflexFile, (*RepTPvec)[i], ErrMsg)) {
			(void) PasteMessage("BuildFieldNameVec : pool error: ",
				ErrMsg);
			return -1;
		}
	}
	/* fix-up FDvec RepText pool index values */
	/* ... only place where FDvec values are changed from read input */ 
	j = 0;
	for (i = *FNc - 1; i >= 0; --i) {		/* note - in reverse order */
		if ((*FDvec)[i]->DataType == RepText) {
			(*FDvec)[i]->Index = (long4) j++;
		}
	}
	if (j != numRepText) {
		(void) strcpy(ErrMsg,
			"BuildFieldNameVec : num RepText error");
		return -1;
	}

	/* clean up VarLenBuf temporary variables */
	QuitBuffer(&FieldNameIndex);
	QuitBuffer(&FieldNameText);
	QuitBuffer(&FieldDirectory);

	return 0;
}
