static const char AUTHOR[] = "@(#)$Id: bldbuf.c,v 1.1 1999/09/24 00:04:36 rk Exp $";
#include <stdio.h>
#include <stdlib.h>
#include "reflex.h"
/*
 *********************************************************************
 *
 *     This software is copyrighted by R.K.Owen,Ph.D. 1995
 *
 * The author, R.K.Owen, of this software is not liable for any
 * problems WHATSOEVER which may result from use  or  abuse  of
 * this software. The author, R.K.Owen, grants unlimited rights
 * to anyone who uses and modifies this  software  for  private
 * non-commercial  use  as  long  as  this copyright and rights
 * notice remains in this software and is made available to all
 * recipients of this software.
 *
 * last known email: rk@owen.sj.ca.us
 *                   libreflex@kooz.sj.ca.us
 *
 *********************************************************************
 */

int BuildBuffer(FILE *In, VarLenBuf *B, char *ErrMsg) {
	size_t RecsRead;
	if (fread(&(B->Len), sizeof(B->Len), 1, In) != 1) {
		(void) PasteMessage("BuildBuffer: fread of Len error", ErrMsg);
		return -1;
	}
	if ((B->Buf = (uchar *) malloc((size_t) B->Len)) == (uchar *) NULL) {
		(void) PasteMessage("BuildBuffer: malloc error", ErrMsg);
		return -1;
	}
	RecsRead = fread(B->Buf, 1, B->Len, In);
	if (RecsRead != B->Len) {
		(void) PasteMessage("BuildBuffer: fread of Buf error", ErrMsg);
		return -1;
	}
	return 0;
}
