/* linkaware.c
   This file released to the public domain by Ben Darnell.
   You may use this file however you wish to make
   LinkMaster-compatible applications.
*/
#include <Pilot.h>
#include "linkaware.h"

Boolean LinkCheck()
{
#ifndef NO_LINKGLOBALS
   static int result; /* 0: not checked; 1: present; 2: not present */
#endif
   Err err;
   DmSearchStateType searchstate;
   UInt cardno;
   LocalID dbid;

#ifndef NO_LINKGLOBALS
   if (result==1) return true;
   else if (result==2) return false;
#endif
   
   err=DmGetNextDatabaseByTypeCreator(true, &searchstate, 'appl', 'Link', true,
				      &cardno, &dbid);
   if (err) {
#ifndef NO_LINKGLOBALS
      result=2;
#endif
      return false;
   } else {
#ifndef NO_LINKGLOBALS
      result=1;
#endif
      return true;
   };
}

Boolean LinkPublish(LinkInfoPtr linkinfo)
{
   Err err;
   DmSearchStateType searchstate;
   UInt cardno;
   LocalID dbid;

   if (!LinkCheck()) {
      MemPtrFree(linkinfo);
      return false;
   };
   
   err=DmGetNextDatabaseByTypeCreator(true, &searchstate, 'appl', 'Link', true,
				      &cardno, &dbid);
   if (err) {
      MemPtrFree(linkinfo);
      return false;
   };
   MemPtrSetOwner(linkinfo, 0);
   SysUIAppSwitch(cardno, dbid, linkAppLaunchReturnLink, (Ptr)linkinfo);

   return true;
}

#ifndef NO_LINKSIMPLE
LinkSimplePtr LinkSimpleNew(DmOpenRef db, Word record_index, CharPtr title)
{
   LinkSimplePtr linkinfo;
   LocalID dbid, app_id;
   UInt cardno, app_card;

   if (title) {
      /* title is truncated to 32 chars or at the first \n */
      int titlelen=32;
      int tmp;

      tmp=StrLen(title);
      if (tmp<titlelen) titlelen=tmp;

      tmp=StrChr(title, '\n')-title;
      if ((tmp>0)&&(tmp<titlelen)) titlelen=tmp;

      linkinfo=MemPtrNew(65+titlelen);
      MemSet(linkinfo, 65+titlelen, 0);
      ErrFatalDisplayIf(!linkinfo, "Not enough memory");
      StrNCopy(((CharPtr)linkinfo)+64, title, titlelen);
       ((CharPtr)linkinfo)[64+titlelen]=0;
   } else {
      linkinfo=MemPtrNew(64);
      MemSet(linkinfo, 64, 0);
   };

   SysCurAppDatabase(&app_card, &app_id);
   DmDatabaseInfo(app_card, app_id,
		  NULL,NULL,NULL,NULL,NULL,
		  NULL,NULL,NULL,NULL,NULL,
		  &linkinfo->creator);

   DmOpenDatabaseInfo(db, &dbid, NULL,NULL, &cardno, NULL);
   DmDatabaseInfo(cardno,dbid, linkinfo->db_name,
		  NULL,NULL,NULL,NULL,NULL,
		  NULL,NULL,NULL,NULL,NULL);

   DmRecordInfo(db, record_index, NULL, &linkinfo->record_id, NULL);

   return linkinfo;
}
#endif /* NO_LINKSIMPLE */


#ifndef NO_LINKSIMPLE
GoToParamsPtr LinkSimpleToGoToParams(LinkSimplePtr linkinfo)
{
   GoToParamsPtr gotoparams;
   LocalID dbid;
   DmOpenRef db;
   Word recordnum;
   Err err;

   dbid=DmFindDatabase(0, linkinfo->db_name);
   db=DmOpenDatabase(0, dbid, dmModeReadOnly);
   err=DmFindRecordByID(db, linkinfo->record_id, &recordnum);
   /* sort of a kludge, but it will prevent fatal errors
      this will catch non-existant uids and deleted records */ 
   if ((err)||(!DmQueryRecord(db, recordnum))) {
      DmCloseDatabase(db);
      return NULL;
   };
   DmCloseDatabase(db);

   gotoparams=MemPtrNew(sizeof(GoToParamsType));
   MemSet(gotoparams, sizeof(GoToParamsType), 0);
   gotoparams->recordNum=recordnum;
   gotoparams->dbCardNo=0;
   gotoparams->dbID=dbid;

   return gotoparams;
}
#endif /* NO_LINKSIMPLE */

#ifndef NO_LINKCONTAINER
void LinkRequest(LinkInfoPtr linkinfo)
{
   Err err;
   DmSearchStateType searchstate;
   UInt cardno;
   LocalID dbid;

   if (!LinkCheck()) {
      MemPtrFree(linkinfo);
      return;
   };
   MemPtrSetOwner(linkinfo, 0);
   err=DmGetNextDatabaseByTypeCreator(true, &searchstate, 'appl', 'Link', true,
				      &cardno, &dbid);
   if (err) {
      MemPtrFree(linkinfo);
      return;
   };
   SysUIAppSwitch(cardno, dbid, linkAppLaunchRequestLink, (Ptr)linkinfo);
}

void LinkFollow(LinkInfoPtr linkinfo)
{
   LinkInfoPtr params;
   DmSearchStateType searchstate;
   UInt cardno;
   LocalID dbid;
   Err err;
   DWord result;
   
   params=MemPtrNew(64);
   MemPtrSetOwner(params, 0);
   MemMove(params, linkinfo, 64);

   err=DmGetNextDatabaseByTypeCreator(true, &searchstate,
				      'appl', params->creator,
				      true, &cardno, &dbid);
   if (err)
      err=DmGetNextDatabaseByTypeCreator(true, &searchstate,
					 'PROX', params->creator,
					 true, &cardno, &dbid);
   if (err) {MemPtrFree(params); return;};
   SysAppLaunch(cardno, dbid, 0,
		linkAppLaunchFollowLinkSubCall, (Ptr)params, &result);
}
#endif /* NO_LINKCONTAINER */

#ifndef NO_LINKHISTORY
void LinkHistoryPush(LinkInfoPtr linkinfo)
{
   Err err;
   DmSearchStateType searchstate;
   UInt cardno;
   LocalID dbid;
   DWord result;
   
   if (!LinkCheck()) {
      MemPtrFree(linkinfo);
      return;
   }
   
   err=DmGetNextDatabaseByTypeCreator(true, &searchstate, 'appl', 'Link', true,
				      &cardno, &dbid);
   if (err) {
      MemPtrFree(linkinfo);
      return;
   };
   MemPtrSetOwner(linkinfo, 0);
   SysAppLaunch(cardno, dbid, 0, linkAppLaunchHistoryPush,
		(Ptr)linkinfo, &result);
}

Boolean LinkHistoryBack()
{
   Err err;
   DmSearchStateType searchstate;
   UInt cardno;
   LocalID dbid;
   DWord result;
   
   if (!LinkHistoryBackCheck())
      return false;
   err=DmGetNextDatabaseByTypeCreator(true, &searchstate, 'appl', 'Link', true,
				      &cardno, &dbid);
   if (err)
      return false;
   SysAppLaunch(cardno, dbid, 0, linkAppLaunchHistoryBack, 0, &result);
   if (!result) /* returns 0 on success */
      return true;
   else
      return false;
}

Boolean LinkHistoryForward()
{
   Err err;
   DmSearchStateType searchstate;
   UInt cardno;
   LocalID dbid;
   DWord result;
   
   if (!LinkHistoryForwardCheck())
      return false;
   err=DmGetNextDatabaseByTypeCreator(true, &searchstate, 'appl', 'Link', true,
				      &cardno, &dbid);
   if (err)
      return false;
   SysAppLaunch(cardno, dbid, 0, linkAppLaunchHistoryForward, 0, &result);
   if (!result) /* returns 0 on success */
      return true;
   else
      return false;
}

Boolean LinkHistoryBackCheck()
{
   DmOpenRef db;
   LinkHistoryPrefsType histprefs;
   Word prefssize;
   
   if (!LinkCheck())
      return false;

   db=DmOpenDatabaseByTypeCreator('HIST', 'Link', dmModeReadOnly);
   if (!db)
      return false;
   
   prefssize=sizeof(histprefs);
   PrefGetAppPreferences('Link', 0, &histprefs, &prefssize, true);

   if (histprefs.current>=DmNumRecords(db)) {
      DmCloseDatabase(db);
      return false;
   };

   DmCloseDatabase(db);
   return true;
}

Boolean LinkHistoryForwardCheck()
{
   LinkHistoryPrefsType histprefs;
   Word prefssize;

   if (!LinkCheck())
      return false;

   prefssize=sizeof(histprefs);
   PrefGetAppPreferences('Link', 0, &histprefs, &prefssize, true);

   return (histprefs.current!=0);
}
#endif /* NO_LINKHISTORY */
