#ifndef _DB_H
#define _DB_H

#include <Common.h>

#include "dbfmt.h"
#include "config.h"

#define prefFlagEnableFind      0x0001
#define prefFlagUpArrowPage     0x0002
#define prefFlagDownArrowPage   0x0004
#define prefFlagPageUpPage      0x0008
#define prefFlagPageDownPage    0x0010

#define DBCreatorID 'DBOS'
#define DBTypeID 'DB99'

#define offsetof(s,m) ( ((ULong) (&(s).m)) - ((ULong)&(s)) )

#define chooserSortOrderAlphabetic 0
#define chooserSortOrderManual     1

typedef struct {
    /* Keep track of what database was opened when we closed last. */
    Boolean dbWasOpen;
    UInt cardNo;
    Char dbName[dmDBNameLength];

    /* Flags */
    Word flags;

    /* Current chooser category. */
    Word ChooserCurrentCategory;
    Boolean ChooserShowAllCategories;
    Boolean ChooserForceRescan;
    Byte ChooserSortOrder;
} DBPrefsType, *DBPrefsPtr;

extern DmOpenRef CurrentDB;
extern Word numFields;
extern DBFieldInfoPtr fields;
extern UInt CurrentRecord;
extern VoidHand CurrentRecordHandle;
extern Boolean DesignNewDB;
extern UInt TopVisibleRecord;
extern Word CurrentCategory;
extern Boolean IsNewRecord;
extern DBPrefsType prefs;
extern Boolean HideSecretRecords;

extern Err   OpenDatabase(UInt, LocalID);
extern void  CloseDatabase(void);
extern Err   CreateDatabase(char *, Word, DBFieldInfoPtr);
extern Err   GetRecord(Word, VoidPtr [], VoidHand *);
extern void  UnpackRecord(VoidPtr, VoidPtr [], int, DBFieldInfoPtr);
extern ULong PackedRecordSize(VoidPtr unpacked[]);
extern void  PackRecord(VoidPtr unpacked[], VoidPtr packed);

extern Boolean ChooserHandleEvent(EventPtr);
extern Boolean DesignViewHandleEvent(EventPtr);
extern Boolean ListViewHandleEvent(EventPtr);
extern Boolean EditViewHandleEvent(EventPtr);
extern Boolean ListPropViewHandleEvent(EventPtr);
extern Boolean ChooserInfoDialogHandleEvent(EventPtr);
extern Boolean HandleCommonMenuEvent(Word menuitemID);

extern void PopupDBPrefs(void);
extern void PopupAppPrefs(void);

extern void GlobalSearch(FindParamsPtr params);

extern Boolean SeekRecord (UIntPtr indexP, Int offset, Int direction);

extern void    DbgPrintF(CharPtr fmt, ...);
extern CharPtr GetStringPtr(Word stringID);
extern Boolean IsNumber(CharPtr s);
extern Long    String2Long(CharPtr cp);
extern Boolean MatchString(CharPtr, CharPtr, Boolean, Boolean);
extern Word GetFlags(DmOpenRef db);
extern void SetFlags(DmOpenRef db, Word flags);

extern void Chooser_AddDatabase(UInt cardNo, CharPtr name);
extern void Chooser_RenameDatabase(UInt cardNo,
				   CharPtr oldName, CharPtr newName);

#endif
