#!/bin/sh
#
# Automate the building of the zip distribution so that we don't have to
# do it manually.

if [ "x$1" = "x" ]; then
  echo usage: $0 VERSION
  exit 0
fi

# Form the filename that we will use.
ver=`echo $1 | sed -e 's/\./_/g'`
zipfile="../db_${ver}.zip"

# Do some initial cleanups.
make distclean
rm -f "$zipfile"

# Add in all normal source files.
zip -l -r "$zipfile" * -x '*.bmp'

# Add in the binary files.
zip "$zipfile" *.bmp

# Now build db.prc (English)
make
zip "$zipfile" db.prc

# Now build db-de.prc (German)
make distclean
make db-de.prc
zip "$zipfile" db-de.prc

# Now build db-nl.prc (Dutch)
make distclean
make db-nl.prc
zip "$zipfile" db-nl.prc

# Final cleanup to leave it nice and spiffy.
make distclean
