/*
 * DB: Database and Application Preference Dialogs
 * Copyright (C) 1998-2001 by Tom Dyas (tdyas@users.sourceforge.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <PalmOS.h>

#include "enum.h"
#include "db.h"

#define GetObjectPtr(f,i) FrmGetObjectPtr((f),FrmGetObjectIndex((f),(i)))

void
PopupDBPrefs(void)
{
    FormPtr form, oldForm;
    ControlPtr ctl;
    LocalID dbID;
    UInt16 cardNo, attr, i;
    Boolean DisableFind;

    DmOpenDatabaseInfo(CurrentSource->db, &dbID, 0, 0, &cardNo, 0);
    DmDatabaseInfo(cardNo, dbID, 0, &attr, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    if (CurrentSource->ops.GetOption_Boolean)
	DisableFind =
	    CurrentSource->ops.GetOption_Boolean(CurrentSource,
						 optionID_DisableGlobalFind);
    else
      DisableFind = false;

    oldForm = FrmGetActiveForm();
    form = FrmInitForm(formID_DBPrefs);
    FrmSetActiveForm(form);

    ctl = GetObjectPtr(form, ctlID_DBPrefs_BackupDB);
    CtlSetValue(ctl, ((attr & dmHdrAttrBackup) == dmHdrAttrBackup) ? 1 : 0);

    ctl = GetObjectPtr(form, ctlID_DBPrefs_DisableFind);
    CtlSetValue(ctl, DisableFind ? 1 : 0);

    if (FrmDoDialog(form) == ctlID_DBPrefs_OkayButton) {
	ctl = GetObjectPtr(form, ctlID_DBPrefs_BackupDB);
	i = CtlGetValue(ctl);
	if (i)
	    attr |= dmHdrAttrBackup;
	else
	    attr &= ~(dmHdrAttrBackup);
	DmSetDatabaseInfo(cardNo, dbID, 0, &attr, 0, 0, 0, 0, 0, 0, 0, 0, 0);

	ctl = GetObjectPtr(form, ctlID_DBPrefs_DisableFind);
	i = CtlGetValue(ctl);
	if (i && !DisableFind)
	    CurrentSource->ops.SetOption_Boolean(CurrentSource,
						 optionID_DisableGlobalFind,
						 true);
	else if (!i && DisableFind)
	    CurrentSource->ops.SetOption_Boolean(CurrentSource,
						 optionID_DisableGlobalFind,
						 false);
    }

    FrmDeleteForm(form);
    FrmSetActiveForm(oldForm);
}

void
PopupAppPrefs(void)
{
    FormPtr form, oldForm;
    ControlPtr ctl;
    ListPtr lst;
    UInt16 i;
    Char * labels[3] = { 0, 0, 0 };

    oldForm = FrmGetActiveForm();
    form = FrmInitForm(formID_AppPrefs);
    FrmSetActiveForm(form);

    labels[0] = CopyStringResource(stringID_Line);
    labels[1] = CopyStringResource(stringID_Page);

    ctl = GetObjectPtr(form, ctlID_AppPrefs_EnableFind);
    i = ((prefs.flags & prefFlagEnableFind) == prefFlagEnableFind) ? 1 : 0;
    CtlSetValue(ctl, i);

    ctl = GetObjectPtr(form, ctlID_AppPrefs_Trigger1);
    lst = GetObjectPtr(form, ctlID_AppPrefs_List1);
    LstSetListChoices(lst, labels, 2);
    LstSetHeight(lst, 2);
    if ((prefs.flags & prefFlagUpArrowPage) == prefFlagUpArrowPage) {
	CtlSetLabel(ctl, labels[1]);
	LstSetSelection(lst, 1);
    } else {
	CtlSetLabel(ctl, labels[0]);
	LstSetSelection(lst, 0);
    }

    ctl = GetObjectPtr(form, ctlID_AppPrefs_Trigger2);
    lst = GetObjectPtr(form, ctlID_AppPrefs_List2);
    LstSetListChoices(lst, labels, 2);
    LstSetHeight(lst, 2);
    if ((prefs.flags & prefFlagDownArrowPage) == prefFlagDownArrowPage) {
	CtlSetLabel(ctl, labels[1]);
	LstSetSelection(lst, 1);
    } else {
	CtlSetLabel(ctl, labels[0]);
	LstSetSelection(lst, 0);
    }

    ctl = GetObjectPtr(form, ctlID_AppPrefs_Trigger3);
    lst = GetObjectPtr(form, ctlID_AppPrefs_List3);
    LstSetListChoices(lst, labels, 2);
    LstSetHeight(lst, 2);
    if ((prefs.flags & prefFlagPageUpPage) == prefFlagPageUpPage) {
	CtlSetLabel(ctl, labels[1]);
	LstSetSelection(lst, 1);
    } else {
	CtlSetLabel(ctl, labels[0]);
	LstSetSelection(lst, 0);
    }

    ctl = GetObjectPtr(form, ctlID_AppPrefs_Trigger4);
    lst = GetObjectPtr(form, ctlID_AppPrefs_List4);
    LstSetListChoices(lst, labels, 2);
    LstSetHeight(lst, 2);
    if ((prefs.flags & prefFlagPageDownPage) == prefFlagPageDownPage) {
	CtlSetLabel(ctl, labels[1]);
	LstSetSelection(lst, 1);
    } else {
	CtlSetLabel(ctl, labels[0]);
	LstSetSelection(lst, 0);
    }

    if (FrmDoDialog(form) == ctlID_AppPrefs_OkayButton) {
	i = CtlGetValue(GetObjectPtr(form, ctlID_AppPrefs_EnableFind));
	if (i != 0)
	    prefs.flags |= prefFlagEnableFind;
	else
	    prefs.flags &= ~(prefFlagEnableFind);

	i = LstGetSelection(GetObjectPtr(form, ctlID_AppPrefs_List1));
	if (i != 0)
	    prefs.flags |= prefFlagUpArrowPage;
	else
	    prefs.flags &= ~(prefFlagUpArrowPage);

	i = LstGetSelection(GetObjectPtr(form, ctlID_AppPrefs_List2));
	if (i != 0)
	    prefs.flags |= prefFlagDownArrowPage;
	else
	    prefs.flags &= ~(prefFlagDownArrowPage);

	i = LstGetSelection(GetObjectPtr(form, ctlID_AppPrefs_List3));
	if (i != 0)
	    prefs.flags |= prefFlagPageUpPage;
	else
	    prefs.flags &= ~(prefFlagPageUpPage);

	i = LstGetSelection(GetObjectPtr(form, ctlID_AppPrefs_List4));
	if (i != 0)
	    prefs.flags |= prefFlagPageDownPage;
	else
	    prefs.flags &= ~(prefFlagPageDownPage);


	/* Force the new value to be in the preferences. */
	PrefSetAppPreferences(DBCreatorID, prefID_GlobalPrefs, 0,
			      &prefs, sizeof(prefs), false);
    }

    FrmDeleteForm(form);
    FrmSetActiveForm(oldForm);

    MemPtrFree(labels[0]);
    MemPtrFree(labels[1]);
}
